-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
disassembler: using (predefined,interpform,stdenv)
  definitions
    -- disassembler produces a source that would assemble to LIprog
    disassembler: callmessage (
	codeMap: interpform!codeMap,
	main_program: processid,
	modulename: charstring,
	stdenv: stdenv!stdenv,
	printmaps: printmaps,
	code: predefined!charstring
      )
    constant (codeMap,main_program, modulename,stdenv,printmaps)
    exit {full}
    exception Unsupported {
      full(codeMap),init(main_program),init(modulename),full(stdenv),
      full(printmaps)};
    disassemblerQ: inport of disassembler  {
      full(codeMap),init(main_program),init(modulename),full(stdenv),
      full(printmaps)};
    disassemblerFn: outport of disassemblerQ;

    -- The internal text representation of an LIprog
    source: ordered table of charstring {init};
    --  print maps:
    printmaps: record (
	execs: predefined!executable_printmappings,
	defs: predefined!definitions_printmappings,
	progid: predefined!executable_id
      );

  end definitions
