-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: parse.d
-- Author: David F. Bacon
-- SCCS Info: @(#)parse.d	1.8 1/9/92

parse: using (errors, posMap) definitions 

  parseDef: callmessage (
      file: charstring,		-- const: file to parse
      filename: charstring,	-- const: name of source file
      id: moduleid,		-- out: id of created definition module
      definitions: definitions_modules, -- out: new module + imported
      printmaps: definitions_printmappings, -- out: printmaps
      constraintMaps: executable_printmappings, -- out: constraint printmaps
      moduleMap: module_printmap, -- out: name/id map for imports
      errors: errors		-- out; errors in concrete syntax
    ) constant (file)
  exit { full };

  parseDefQ: inport of parseDef { init(file), init(filename) };
  parseDefFn: outport of parseDefQ;


  parseProc: callmessage (
    file: charstring,		-- constant: file to process
    filename: charstring,	-- constant: name of source file
    absprog: program,		-- out: generated absprog
    defmap: definitions_printmappings, -- out: printnames for definitions
    execmap: executable_printmappings, -- out: names for processes, constraints
    posmap: position_mappings,	-- out: position of each statement
    moduleMap: module_printmap, -- out: name/id map for imports
    links: linkedPrograms,	-- out: linked programs
    errors: errors		-- out: errors in concrete syntax
  ) constant (file)
    exit { full };

  parseProcQ: inport of parseProc { init(file), init(filename) };
  parseProcFn: outport of parseProcQ;


  module_printmap: table of module_printrec { full } keys (name) (id);

  module_printrec: record (
      name: charstring,
      id: moduleid 
    );
  
  
  linkedPrograms: table of linkedProgram { full, checked(program) } keys (id) (name);
  
  linkedProgram: record (
      id: processid,
      name: charstring,
      program: program
    );

end definitions
