/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: cfunc.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)cfunc.ch	1.12 8/28/91";
#endif

#include "cfunc.h"
#include "storage.h"

#include "cload.cd"

extern cproc_entry cproctab[];

#define C_Load_CPROCESS 0
				/* position of the C_Load function itself in */
				/*  the cproctab table. */


CProc(C_cload)
{
    status doload();

    lobject(CMsg);
    lobject(Capa);
    objectp Initp;
    dfd_enumeration cprocess;

    Initp = & current->ep.c->initport;

    (void) copy(CMsg, Bottom);
    if (c_receive(CMsg, Initp) is SUCCESS) {

	cprocess = lookup_cprocess(stringval(CMsg@cload__name));

	if (cprocess is 0) {
	    /* c_return_exception(sched, CMsg, CLoad.badName); */
	    c_discard(sched, CMsg);
	}
	else {			/* all ok, proceed with the load. */
	    if (doload(cprocess, sched, Capa) &&
		(wrap(CMsg@cload__capability, Capa, nil) is Normal)) {
		c_return(sched, CMsg); /* return the filled-in callmessage */
	    }
	    else {			/* couldn't load it */
		c_discard(sched, CMsg); /* return with exception discarded */
	    }
	}
    }
    else if (c_disconn(Initp)) {
      c_discard(sched, Initp);
      c_endprocess(sched, current);
    }
    else
      c_wait(sched, current, Initp); /* wait for the next request */
}


static status
doload(cprocess, sched, Outport)
dfd_enumeration cprocess;
schedp sched;
objectp Outport;
{
    pcb *newproc;
    cprocessdata *newdata;
    counter datasize;

    newproc = nil;
    newdata = nil;

    if ((newproc = new(pcb)) is nil) goto cleanup;
    newproc->interpreter = cproctab[cprocess].funcp;
    newproc->ip = 0;
    newproc->selecting = FALSE;
    newproc->type = CProcess;
    newproc->next = nil;
#ifdef TRACE
    newproc->call_level = 0;
#endif

    /* allocate at least enough room for the initport */
    datasize = (counter) (cproctab[cprocess].size +
			  sizeof(cprocessdata) - ARBSIZE*sizeof(int));
    newdata = (cprocessdata *) getmain((counter) (datasize + sizeof(counter)));
    if (newdata is nil) goto cleanup;
    *((counter *) newdata) = datasize + sizeof(counter);
    newdata = (cprocessdata *) (((char *) newdata) + sizeof(counter));
    newproc->ep.c = newdata;
    
    if (c_new_inport(& newdata->initport) is FAILURE) goto cleanup;

    (void) c_connect(Outport, & newdata->initport);
				/* connect to initport, ignoring non- */
				/*  possibility of depletion, since we can */
				/*  only deplete by overflowing the connect */
				/*  count. */
    sched->add(sched, newproc);	/* start scheduling the new process */
    return(SUCCESS);

  cleanup:
    /* here when some step failed... reclaim any stg we got and fail */
    if (newproc isnt nil)
      { dispose(newproc,pcb); }
    if (newdata isnt nil)
      { freemain(newdata,(counter) sizeof(object) + cproctab[cprocess].size); }
    return(FAILURE);
}



void
load_cload(sched, Outport)
schedp sched;
objectp Outport;
{
    void abort_nili();

    if (doload(C_Load_CPROCESS, sched, Outport) isnt SUCCESS) {
	nilerror("load_cload", "Couldn't load Cload process");
	abort_nili("load_cload");
	/*NOTREACHED*/
    }
}




/******************************************************************************
 *                   Programming-in-the-Large Operations                      *
 *****************************************************************************/

status
c_new_inport(Inport)
objectp Inport;
{
    if (new_inport(Inport) is Normal) 
      return(SUCCESS);
    else
      return(FAILURE);
}


status
c_connect(Outport, Inport)
objectp Outport;
objectp Inport;
{
    if (connect(Outport, Inport) is Normal)
      return(SUCCESS);
    else
      return(FAILURE);
}


predef_exception
c_send(sched, Outport, Msg)
schedp sched;
objectp Outport;
objectp Msg;
{
    return(h_scall(o_send, sched, Outport, Msg, nil));
}


status 
c_receive(Msg, Inport)
objectp Msg;
objectp Inport;
{
    if (c_empty(Inport))
      return(FAILURE);		/* port is empty */

    (void) receive(Msg, Inport);
    return(SUCCESS);
}


void
c_return(sched, Callmsg)
objectp Callmsg;
schedp sched;
{
    (void) h_scall(o_return, sched, Callmsg, nil);
}


status 
c_empty(Inport)
objectp Inport;
{
    lobject(Test);


    (void) empty(Test, Inport);

    if (booleanval(Test))
      return(SUCCESS);		/* port is empty */
    else
      return(FAILURE);		/* port has messages */
}


flag
c_disconn(Inport)
objectp Inport;
{
  return(Inport->value.inport->refcount is 0);
}
    
void

c_discard(sched, Obj)
schedp sched;
objectp Obj;
{
    (void) h_scall(o_discard, sched, Obj, nil);
}

/******************************************************************************
 *                      Scheduling Operations                                 *
 *****************************************************************************/

void
c_wait(sched, current, Inport)
schedp sched;
pcb *current;
objectp Inport;
{
    if (not c_empty(Inport))
      return;			/* still some messages: don't go to sleep. */
    
    Inport->value.inport->info.inport.waiting_owner = current;
				/* wait on this inport */
    sched->suspend(sched, current, nil);
				/* take us out of the ready ring */
}


void
c_endprocess(sched, current)
schedp sched;
pcb *current;
{
  counter datasize;
  handlr_stack *x, *next;

  current->ep.c = (cprocessdata *)
    (((char *) current->ep.c) - sizeof(counter));
  datasize = *((counter *) current->ep.c);
  { freemain(current->ep.c, datasize); }
  sched->kill(sched, current);
}

