-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: objectcacheimp.d
-- Author: David F. Bacon
-- SCCS Info: @(#)objectcacheimp.d	1.4 1/11/92

objectCacheImp: using (unix, common) definitions

-- data structure for implementing an object cache: a table of
-- (filename,mtime,polymorph) triples keyed by filename.  note that this means
-- that using symlinks is a big no-no, since it will confuse the cache.

  cache: table of cacheEntry { full } keys (filename);

  cacheEntry: record (
      filename: charstring,	/* full name of file */
      mtime: integer,		/* time last modified (for cache invalidate) */
      object: polymorph		/* cached object */
  );

end definitions
