-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: makehermes.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)makehermes.p	1.10 1/25/92"
-- description:
-- this is the interface to the hermes make facility.  it is invoked by the 
-- command:
-- ``hermes makehermes <rootname>''
-- where <rootname> is the name of the root file (directory) to be 'made'.  It
-- is assumed that if rootname is not in the current directory, its path 
-- is given.  

makehermes: using(main,common,make,getdep)
linking(getdep,make)
process (initQ: mainQ)

declare
  initM: main;
  make: MakeFunc;
  setupGetdep: setupGetDepService;
  getDependencies: getDependenciesFunc;
  graph: dependencyGraph;
  root: nodeIDs;
  argv: charstringList;
  arg: charstring;

  options: charstringList;
  actionType: actionType;
  actionControl: actionControl;
  errorControl: errorControl;
  debugControl: debugControls;
begin
   receive initM from initQ;

   -- initialize defaults
   actionControl <- 'Inconsistent';
   errorControl <- 'Continue Other Paths';  
   actionType <- 'compile';
   argv := initM.argv;          -- copy the parameters
   block begin 
     remove arg from argv[0];   -- get rid of "hermes"
     remove arg from argv[0];   -- get rid of "makehermes"
   on (notfound)
     call initM.terminal.putString("Strange command line arguments: ");
     for a in initM.argv[] inspect
       call initM.terminal.putString(a | " ");
     end for;
     call initM.terminal.putLine("");
     exit inputError;
   end block;
   -- extract options if they exist
   extract options from word in argv where(word[0] = '-');
   new debugControl;
   for opt in options where('true')
   inspect
     for char in opt where(position of char > 0) inspect  -- not the '-' char
       block declare
	 debug: debugControl;
       begin
	 select char
	 where('n')  actionControl <- 'None';
	 where('i')  actionControl <- 'Inconsistent';
	 where('a')  actionControl <- 'All';
	 where('s')  errorControl <- 'Stop';
	 where('g')  errorControl <- 'Ignore';
	 where('o')  errorControl <- 'Continue Other Paths';
	 where('p')  actionType <- 'print';
	 where('c')  actionType <- 'compile';
	 where('D')  debug <- 'dependencies'; exit debug;
	 where('Y')  debug <- 'decisions'; exit debug; -- Y is for "why?"
	 where('A')  debug <- 'actions'; exit debug;
	 where('T')  debug <- 'trace'; exit debug;
	 otherwise  
	   call initM.terminal.putLine
	       ("Unknown option flag: " | every of opt[position of char]);
	   exit inputError;
	 end select;
       on exit(debug)
	 block begin
	   insert debug into debugControl;
	 on (duplicateKey)
	 end block;
       end block;
     end for;
   end for;
   if exists of debugControl['actions'] then
     call initM.terminal.putLine("make: 'actions' debug mode not yet implemented");
   end if;
   if exists of debugControl['trace'] then
     call initM.terminal.putLine("make: 'trace' debug mode not yet implemented");
   end if;
   
   -- the remaining arguments must be the modules to make
   new root;
   while size of argv > 0 repeat
     block declare
       modName: charString;
       modType: charString;
       junk: char;
       id: nodeID;
     begin
       remove modname from argv[0];   
       extract modType from c in modName where
	   (not exists of d in modName where
	     (d = '.' and position of d > position of c));
       if modName = "" then	-- treat no extension as a .target file
	 modName <- modType;
	 modType <- ".target";
       end if;
       select modType
       where (".d")
	 modType <- "definitions source";
       where (".do")
	 modType <- "definitions module";
       where (".p")
	 modType <- "process source";
       where (".po")
	 modType <- "process module";
       where (".target")
	 modType <- "target list";
       otherwise
	 call initM.terminal.putLine(
	   "I don't know how to build this target: " | modName | modType);
	 exit inputError;
       end select;

       new id;
       id.name <- modName;
       id.type <- modType;
       insert id into root;
     end block;
   end while;

   -- load the getdependencies function
   setupGetdep <- create of process getdep;
   getDependencies <- setupGetdep(initM.rm, initM.terminal, actionType);
   block begin
     -- finally, load and call make
     make <- procedure of process make;
     graph <- make(root,actionControl,errorControl,debugControl,
       getDependencies,initM.terminal);
   on (MakeIntf.NotMade)
     call initM.terminal.putline("Make did not complete");
   on (MakeIntf.Circular)
     call initM.terminal.putline("Circular dependencies detected");
   end block;

   return initM;  

 on exit (inputError)
 on (others)
   print charstring#"unexpected exception raised in makehermes";

end process


