-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: dupebooleans.p
-- Author: Andy Lowry
-- SCCS Info: @(#)dupebooleans.p	1.3 3/11/91

-- Reads booleans from a boolean pipe named stdin, and copies each
-- string to several outgoing boolean pipes, whose names are given as
-- command line arguments.

dupebooleans: using (main, booleanpipe, common)

process (Q: mainQ)
  
declare
  args: main;
  stdin: booleanQ;
  outport: booleanPort;
  outports: booleanPorts;
  bool: boolean;
begin
  receive args from Q;
  
  -- get all the pipe ends we'll need
  unwrap stdin from args.rm.get("stdin", "boolean") {init};

  new outports;
  for arg in args.argv where (position of arg >= 2) inspect
    unwrap outport from args.rm.get(arg, "boolean") {init};
    insert outport into outports;
  end for;
  
  while 'true' repeat
    receive bool from stdin;
    for p in outports[] inspect
      send copy of bool to p;
    end for;
  end while;
  
end process

