-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: dupestrings.p
-- Author: Andy Lowry
-- SCCS Info: @(#)dupestrings.p	1.3 3/11/91

-- Reads strings from a string pipe named stdin, and copies each
-- string to sevral outgoing string pipes, whose names are given as
-- command line arguments.

dupestrings: using (main, stringpipe, common)

process (Q: mainQ)
  
declare
  args: main;
  stdin: stringQ;
  outport: stringPort;
  outports: stringPorts;
  s: charString;
begin
  receive args from Q;
  
  -- get all the pipe ends we'll need
  unwrap stdin from args.rm.get("stdin", "string") {init};

  new outports;
  for arg in args.argv where (position of arg >= 2) inspect
    unwrap outport from args.rm.get(arg, "string") {init};
    insert outport into outports;
  end for;
  
  while 'true' repeat
    receive s from stdin;
    for p in outports[] inspect
      send copy of s to p;
    end for;
  end while;
  
end process

