-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: selectstrings.p
-- Author: Andy Lowry
-- SCCS Info: @(#)selectstrings.p	1.3 3/11/91

-- This process takes a stream of strings on stdin and a stream of
-- booleans on a pipe named 'mask'.  For each string, if the
-- corresponding mask boolean is true, the string is sent on stdout.
-- Otherwise it is discarded.

selectstrings: using (main, stringpipe, booleanpipe)

process (Q: mainQ)
  
declare
  args: main;
  stdin: stringQ;
  stdout: stringPort;
  masks: booleanQ;
  s: charString;
  mask: boolean;
begin
  receive args from Q;
  
  -- gather the necessary pipes
  unwrap stdin from args.rm.get("stdin", "string") {init};
  unwrap masks from args.rm.get("mask", "boolean") {init};
  unwrap stdout from args.rm.get("stdout", "string") {init};
  
  while 'true' repeat
    receive s from stdin;
    receive mask from masks;
    if mask then
      send s to stdout;
    end if;
  end while;
  
end process
     
