-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
chainedRM: using (rmanager, chainedRM) 
  
  process (initQ: chainedRMInitQ)

  declare
    initArgs: chainedRMInit;
    
    rmList: rmList;	       
    mainRM: rManager;
    
    postQ: PostResourceQ;	-- post resource
    insertQ: InsertResourceQ;	-- insert a resource
    getQ: GetResourceQ;		-- get resource (copy)
    removeQ: GetResourceQ;	-- get resource (remove)
    deleteQ: DeleteResourceQ;	-- delete resource
    
    postArgs: PostResource;
    insertArgs: insertResource;
    getArgs: GetResource;
    removeArgs: GetResource;
    deleteArgs: DeleteResource;
  
  begin
    new postQ; new insertQ; new getQ; new removeQ; new deleteQ;
    
    receive initArgs from initQ;
    new initArgs.rm;
    connect initArgs.rm.post to postQ;
    connect initArgs.rm.insert to insertQ;
    connect initArgs.rm.get to getQ;
    connect initArgs.rm.remove to removeQ;
    connect initArgs.rm.delete to deleteQ;

    rmList := initArgs.rmList;
    mainRM := initArgs.postingRM;
    
    return initArgs;
    
    while boolean#'true' repeat
	select
	    
	  event postQ
	    receive postArgs from postQ;
	    send postArgs to mainRM.post;
	    
	  event insertQ
	    receive insertArgs from insertQ;
	    send insertArgs to mainRM.insert;
	    
	  event getQ
	    receive getArgs from getQ;
	    block begin
		for rm in rmList[] inspect
		    block begin
			call rm.get(getArgs.resourceName, 
			    getArgs.parameter, getArgs.resource);
			return getArgs;
			exit getDone;
		      on (getResource.accessDenied)
			return getArgs exception accessDenied;
			exit getDone;
		      on (getResource.notFound)
			-- continue
		      on exit (getDone)
			exit getDone;
		      on (others)
			discard getArgs;
			exit getDone;
		      end block;
		  end for;
		return getArgs exception NotFound;
	      on exit (getDone)
		-- done
	      end block;
	    
	  event removeQ
	    receive removeArgs from removeQ;
	    block begin
		for rm in rmList[] inspect
		    block begin
			call rm.remove(removeArgs.resourceName, 
			    removeArgs.parameter, removeArgs.resource);
			return removeArgs;
			exit removeDone;
		      on (getResource.accessDenied)
			return removeArgs exception accessDenied;
			exit removeDone;
		      on exit (removeDone)
			exit removeDone;
		      on (others)
			discard removeArgs;
			exit removeDone;
		      on (getResource.notFound)
			-- continue
		      end block;
		  end for;
		return removeArgs exception NotFound;
	      on exit (removeDone)
		-- done
	      end block;
	    
	  event deleteQ
	    receive deleteArgs from deleteQ;
	    send deleteArgs to mainRM.delete;
	    
	  otherwise
	  end select;
      end while;
  end process
