-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: atoi.p
-- Author: David Bacon
-- SCCS Info: @(#)atoi.p	1.3 3/13/90

-- This process takes a string of digits and converts it into an
-- integer.  An initial sign is allowed.

atoi: using (string)

process (Q: string2intQ)
  
declare
  args: string2int;
  sign: integer;
  scopy: charstring;
  zcode: integer;
  ten: integer;
begin
  receive args from Q;

  args.int := 0;
  scopy := args.string;
  zcode <- convert of char#'0';
  ten <- 10;

  -- handle first char... sign or digit
  block declare
    c: char;
  begin
    remove c from scopy[0];
    select c
    where ('+')
      sign <- 1;
    where ('-')
      sign <- -1;
    otherwise
      sign <- 1;
      args.int <- (convert of c) - zcode;
    end select;
  end block;
  
  for c in scopy[] inspect
    args.int <- args.int * ten + (convert of c) - zcode;
  end for;
  
  args.int <- args.int * sign;

  return args;
  
end process
