-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: itoa.p
-- Author: David Bacon
-- SCCS Info: @(#)itoa.p	1.2 3/13/90

itoa: using (string) process (q: int2stringQ)
    
  declare
    args: int2string;
    int: integer;
    negative: boolean;
    
  begin
    receive args from q;
    
    new args.string;
    int := args.int;
    
    if int < 0 then
	int := - int;
	negative := 'true';
      else
	negative := 'false';
      end if;
    
    while int > 0 repeat
	insert convert of (convert of char#'0' + int mod 10)
	   into args.string at 0;
	int := int / 10;
      end while;
    
    if size of args.string = 0 then
	args.string := "0";
      end if;
    
    if negative then
	insert '-' into args.string at 0;
      end if;

    return args;
  
  end process
   
    
