-- (C) Copyright International Business Machines Corporation 28 November,
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: normalize3.p
-- Author: William Silverman
-- SCCS Info: @(#)normalize3.p	1.1 12/7/90

-- This process normalizes a fraction, represented by three integers and
-- an exponent.  The fraction is scaled up by a power of two, and the
-- exponent (of 2) is decremented accordingly.

-- constraints:
--   low, mid, high are positive, and at least one of them is non-zero.
--	0 <= low; 0 <= mid; 0 <= high; low+mid+high > 0;
--   max is a power of 2, representing the fraction point, which is greater
--   than each of low, mid, high.
--	max = (max/2)*2; max > low; max > mid; max > high

normalize3: using (string)

process (Q: normalizeQ)

declare

  args: normalize;
  compare: integer;
  low: integer;
  mid: integer;

begin

  receive args from Q;

  compare <- args.max/2;
  while args.high < compare repeat
    low <- 2*args.low;
    mid <- 2*args.mid + low/args.max;
    args.high <- 2*args.high + mid/args.max;
    args.mid <- mid mod args.max;
    args.low <- low mod args.max;
    args.exponent <- args.exponent - 1;
  end while;

  return args;
  
end process
