-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: string.d
-- Author: David Bacon
-- SCCS Info: @(#)string.d	1.4 12/7/90

string: using () definitions
    
    int2string: callmessage (
	int: integer,
	string: charstring
      )
    constant (int)
    exit { full };
    
    int2stringQ: inport of int2string { init(int) };
    int2stringFn: outport of int2stringQ;
    

    string2int: callmessage (
	string: charstring,
	int: integer
      )
    constant (string)
    exit { full }
    exception badFormat { init(string) };
    
    string2intQ: inport of string2int { init(string) };
    string2intFn: outport of string2intQ;


--  T E M P O R A R Y  --
    converted_real : real of accuracy 1/2000000000;
--                     --
    
    
    real2string: callmessage (
	real: converted_real,
	string: charstring
      )
    constant (real)
    exit { full };
    
    real2stringQ: inport of real2string { init(real) };
    real2stringFn: outport of real2stringQ;
    
    
    string2real: callmessage (
	string: charstring,
	real: converted_real
      )
    constant (string)
    exit { full }
    exception badFormat { init(string) };
    
    string2realQ: inport of string2real { init(string) };
    string2realFn: outport of string2realQ;

    justify: callmessage (
	inString: charstring,	-- string to justify
	size: integer,		-- size of field (negative means left justify)
	outString: charstring	-- justified string
      )
    constant (inString, size)
    exit { full };
    
    justifyQ: inport of justify { init(inString), init(size) };
    justifyFn: outport of justifyQ;

    
    normalize: callmessage (
	max: integer,		-- power of 2 bound on parts
	low: integer,		-- low part of extended number
	mid: integer,		-- middle part of extended number
	high: integer,		-- high part of extended number
	exponent: integer	-- exponent of extended number
      )
      constant(max)
    exit { full };
    
    normalizeQ: inport of normalize { full };
    normalizeFn: outport of normalizeQ;

  end definitions

