/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* File: Makefile */
/* Author: David F. Bacon */
/* SCCS Info: @(#)Makefile	1.10 2/7/92 */

/* This is the makefile for the bootstrapping version of the Hermes typechecker. */
/* Since typemarks are not included in all of the code, some versions must be */
/* compiled twice, once without checking and once with.  These are the *.bs  */
/* files in the $(COMMOND) directory. */

TCDEFDIR =	$(HROOT)/type/defs
TCCOMDIR =	$(HROOT)/type/common

/* #ifdef'd sources from $(TCCOMDIR) */
BSSRC	=	interfacecheck.bs stmtchecker.bs recheckinfer.bs type.bs \
		qualchecker.bs
BSINT	=	interfacecheck.p stmtchecker.p recheckinfer.p type.p \
		qualchecker.p
BSOBJ	=	interfacecheck.po stmtchecker.po recheckinfer.po type.po \
		qualchecker.po
BSOBJZ	=	interfacecheck.po.Z stmtchecker.po.Z recheckinfer.po.Z type.po.Z \
		qualchecker.po.Z

/* sources required only for bootstrapping */
BOOTSRC=	dummy_class.p
BOOTOBJ=	dummy_class.po
BOOTOBJA=	dummy_class.po.Z

/* all together now... */
SRC	=	$(BOOTSRC)
INT	=	$(BSINT)
PROCOBJS =	$(BSOBJ) $(BOOTOBJ)
PROCOBJSZ =	$(BSOBJZ) $(BOOTOBJZ)

#include "includefile"

EXTRACPPFLAGS =	-UFullChecking -Udebug

DEFPATH	=	$(TCDEFDIR):$(DEFDIR)
LINKPATH =	.:$(TCCOMDIR)

all: $(SRC) $(INT) compileprocs

/* *.bs files from $(TCCOMDIR) */

#include "../common/bsmake"

/* extra dependencies for the bootstrap version */
type.po:	dummy_class.po

/* following removes all the .po files from the current version's */
/* installed binaries directory so they won't interfere with a build */
/* that needs to use the bootstrapper */
cleanbins:
	( cd $(PROCDIR) ; rm -f type.po )
