-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: softcoerce.p
-- Author: Rob Strom
-- SCCS Info: @(#)softcoerce.p	1.1 7/27/89

-- Function: Determine the soft coercions needed to drop a set of attributes
-- Algorithm:
-- 1. Pick constraints in the order of shortest first.
--    This way, when two coercions conflict, the earlier always takes precedence.
--    INIT(X) < CASE(X, X.A) < INIT(X.A)
--    Count 2 points for each component in first object; 1 point for 'case'
--    Get coercion (hide or discard).
--    If a coercion of a parent is in the list, don't insert the coercion.
--    Otherwise insert the coercion
SoftCoerce : USING( Predefined, tscheck  ) PROCESS ( SoftCoerceInit : SoftCoerceInport )
  DECLARE
    FP: SoftCoerceCall;
    Precedence: Integer; -- precedence: 2*size(components) + 1 if 'case'
    Nothing: Empty;
  BEGIN
    RECEIVE FP FROM SoftCoerceInit;
    NEW FP.Coercions;
    Precedence <- 0;
    WHILE (SIZE OF FP.Drops > 0)
      REPEAT
        BLOCK
          DECLARE
            Attribute: Attribute; -- being dropped
            Coercion: Statement; -- coercion which drops it
          BEGIN
            REMOVE Attribute FROM A IN FP.Drops WHERE((EVALUATE APrec: Integer FROM
              INSPECT Object IN A.Objects [0]
                BEGIN
                  APrec <- 2 * SIZE OF Object.Components;
                  IF CASE OF A.Name = 'case'
                    THEN
                      APrec <- APrec + 1;
                    END IF;
                END INSPECT;
              END) = Precedence);
            NEW Coercion;
            BLOCK
              DECLARE
                Coercand: ObjectName; -- coercion operand
              BEGIN
                SELECT (CASE OF Attribute.Name)
                  WHERE ('initialized')
                    Coercion.Operator <- 'discard';
                    REMOVE Coercand FROM Object IN Attribute.Objects WHERE('true');
                  WHERE ('case')
                    Coercion.Operator <- 'hide';
                    REMOVE Coercand FROM Object IN Attribute.Objects WHERE(POSITION OF Object = 0);
                  OTHERWISE -- 'checked' or 'checkeddefinitions' or 'constraint'
                    EXIT Ignore;
                  END SELECT;
                IF EXISTS OF DominatingCoercion IN FP.Coercions WHERE(EVALUATE Dominates: Boolean FROM
                  INSPECT DominatingCoercand IN DominatingCoercion.Operands[]
                    BEGIN
                      Dominates <- SIZE OF DominatingCoercand.Components <= SIZE OF Coercand.Components;
                      IF Dominates
                        THEN
                          Dominates <- DominatingCoercand.Root = Coercand.Root;
                          IF Dominates
                            THEN
                              Dominates <- FORALL OF DominatingComponent IN DominatingCoercand.Components WHERE(DominatingComponent = Coercand.Components[POSITION OF DominatingComponent]);
                            END IF;
                        END IF;
                    END INSPECT;
                  END)
                  THEN
                    DISCARD Coercand;
                  ELSE 
		    NEW Coercion.Operands;
		    INSERT Coercand INTO Coercion.Operands;
		    Coercion.Id <- UNIQUE;
		    UNITE Coercion.Qualifier.Empty FROM Nothing;
		    NEW Coercion.Prag;
		    INSERT Coercion INTO FP.Coercions;
		  END IF;
              ON EXIT (Ignore)
              END BLOCK;
          ON (NotFound)
            Precedence <- Precedence + 1;
          END BLOCK;
      END WHILE;
--    /* debug */ FOR C IN FP.Coercions WHERE ('true')
--      INSPECT
--        CALL FP.Services.Outside.Terminal.PutLine(FP.Services.Debug.FormatStatement(FP.Services.Debug, FP.Declarations, FP.Context.InferredDcls, FP.Definitions, FP.Context.DefinitionsMap, FP.Context.ExecutableMap, C));
--      END FOR;
    RETURN FP;
  END PROCESS
