-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: softglb.p
-- Author: Rob Strom
-- SCCS Info: @(#)softglb.p	1.1 7/27/89

-- Function: Compute typestate and "drops list" for soft coercions at merge point
-- Algorithm:
-- 1A. If the target hasn't been branched to, GLB is just current typestate
--     Remove from targetTS any attrs whose root is not in scope at destination
--     If such a root is not INSPECTING at source, include in Drops list.
--     NOTE: 1. This code is codegen-specific
--     NOTE: 2. This code assumes the same variable cannot be an induction
--              variable and an ordinary variable.  (true in current front-end.)
-- 1B. If the target has been branched to, remove any attributes from
--     targetTS which were not in source, and put on Drops list.
--     For each attr in sourceTS not in targetTS, put on Drops list
--     unless root in INSPECTING at source and out of scope at target.
--     The result will be that targetTS will be set to targetTS intersect sourceTS
softglb : USING( Predefined, tscheck  ) PROCESS ( SoftGLBInit : SoftGLBInport )
  DECLARE
    FP: SoftGLBCall;
    NotInIntersectionAttributes: Typestate; -- attributes which can't be propagated to a branch point because there's another source which doesn't have them
  BEGIN
    RECEIVE FP From SoftGLBInit;
    IF option # (CASE OF FP.TargetTS) = option # 'absent'
      THEN
        -- 1A. 
        UNITE FP.TargetTS.Branched FROM (EVALUATE CoercionInfo: CoercionInfo FROM
          BLOCK
            DECLARE
              OutOfScopeAttributes: Typestate; -- attributes which can't be propagated to a branch point because they refer to objects no longer in scope
            BEGIN
              NEW CoercionInfo;
              CoercionInfo.TargetTS := FP.CurrentTS;
              NEW CoercionInfo.Drops;
              IF FP.TargetLevel < CONVERT OF SIZE OF FP.Context.Scopes - 1
                THEN -- optimization because we do the following FOR loop badly
                  FOR Scope IN FP.Context.Scopes WHERE(CONVERT OF POSITION OF Scope > FP.TargetLevel)
                    INSPECT
                      EXTRACT OutOfScopeAttributes FROM A IN CoercionInfo.TargetTS WHERE(EXISTS OF Object IN A.Objects WHERE(Object.Root.Scope = Scope));
                      MERGE EVERY OF Attribute IN OutOfScopeAttributes WHERE(NOT EXISTS OF InspectingRoot IN FP.Context.Inspecting WHERE(EXISTS OF Object IN Attribute.Objects WHERE(Object.Root = InspectingRoot))) INTO CoercionInfo.Drops;
                  END FOR;
                END IF;
            END BLOCK;
          END);
      ELSE
        -- 1B. 
        REVEAL FP.TargetTS.Branched;
        EXTRACT NotInIntersectionAttributes FROM D IN FP.TargetTS.Branched.TargetTS WHERE(NOT EXISTS OF A IN FP.CurrentTS WHERE(A = D));
        MERGE NotInIntersectionAttributes INTO FP.TargetTS.Branched.Drops;
	FOR DropFromHere IN FP.CurrentTS WHERE(NOT EXISTS OF A IN FP.TargetTS.Branched.TargetTS WHERE(A = DropFromHere))
	  INSPECT
	    IF FORALL OF Object IN DropFromHere.Objects WHERE(EVALUATE NotDroppedQuopy: Boolean FROM
	      NotDroppedQuopy <- NOT EXISTS OF I IN FP.Context.Inspecting WHERE(Object.Root = I);
	      IF NotDroppedQuopy
	        THEN
	        ELSE
	          NotDroppedQuopy <- CONVERT OF POSITION OF Scope IN FP.Context.Scopes WHERE(Scope = Object.Root.Scope) <= FP.TargetLevel;
	        END IF;
	      END)
	      THEN
		BLOCK
		  BEGIN
		    INSERT COPY OF DropFromHere INTO FP.TargetTS.Branched.Drops;
		  ON (DuplicateKey)
		  END BLOCK;
	      ELSE
	      END IF;
	  END FOR;
      END IF;
    RETURN FP;
  END PROCESS
