-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
writewin: using (predefined,common,wininternal,fdhandlers,terminalio)
process (Q: writeHandlerQ)
declare
  args: writeHandler;
  write: writeFn;
  close: signalPort;
  shutdown: signalQ;
  putCharQ: putCharQ;
  putStringQ: putStringQ;
  putLineQ: putStringQ;
  empty: empty;
begin
  -- servers type process
  receive args from Q;
  write <- args.write;
  close <- args.close;
  shutdown <- args.shutdown;
  new putCharQ;
  connect args.putChar to putCharQ;
  new putStringQ;
  connect args.putString to putStringQ;
  new putLineQ;
  connect args.putLine to putLineQ;
  return args;
  while (boolean#'true') repeat
    -- service the next call
    select
    event putCharQ
      -- put a char
      block  declare
	putChar: putCharIntf;
	temp: charstring;
      begin
	block begin
	  receive putChar from putCharQ;
	on (disconnected)
	  exit done;
	end block;
	new temp;
	insert (copy of putChar.char) into temp;
	if (write(temp)) then
	  return putChar;
	else
	  exit WriteError;
	end if;
      on (disconnected, write.discarded)
	exit WriteError;
      end block;
    event putStringQ
      -- put a String
      block declare
	putString: putStringIntf;
      begin
	receive putString from putStringQ;
	if (write(putString.string)) then
	  return putString;
	else
	  exit WriteError;
	end if;
      on (disconnected, write.discarded)
	exit WriteError;
      end block;
    event putLineQ
      -- put a Line
      block declare
	putLine: putStringIntf;
	temp: charstring;
      begin
	receive putLine from putLineQ;
	temp := putline.string;
	insert 'NL' into temp;
	if (write(temp)) then
	  return putLine;
	else
	  discard putLine;
	  exit WriteError;
	end if;
      end block;
    event shutdown
      receive empty from shutdown;
      -- Shut down by closewin... just curl up and die
      exit WriteError;
    otherwise
      -- this can never put executed. 
    end select;
  end while;
on exit(WriteError)
  -- Something failed, or we were told to shutdown... send shutdown
  -- signal to C process in case it hasn't been done, and then die
  block begin
    send empty to close;
  on (disconnected)
    -- who cares...
  end block;
on exit(done)
  -- Our inport became disconnected... nobody can ever write on this
  -- window anymore.  We don't want to kill the window, though,
  -- because other processes may still want to read
end process
