(in-package "LAPIDARY")
;(in-package "USER" :use '("KR" "LISP"))

(load "~bvz/garnet/alpha/gadgets/menubar-loader")
(load "~bvz/garnet/alpha/gadgets/radio-buttons-loader")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; pull down menu
(defun LapMenuFun (gadget menu-item submenu-item)
 (unless (null submenu-item) (format t "~% ~S" submenu-item)))

(create-instance 'LAP-MENU garnet-gadgets:menubar
 (:selection-function #'LapMenuFun)
 (:items '(
   ("file" nil  (
     ("load gadget")
     ("save gadget")
     ("add  gadget")
     ("quit")
     ))
   ("Edit" nil  (
     ("make copy" )
     ("make instance" )
     ("delete object" )
     ("delete window")
     ))
   ("Properties" nil  (
     ("filling style" )
     ("line style")
     ("draw function" )
     ("list properties" )
     ("text properties" )
     ("name object" )
     ))
   ("Arrange" nil  (
     ("bring to front")
     ("send to back")
     ("make aggregadget" )
     ("ungroup" )
     ("parameters")
     ))
   ("constraints"   nil  (
     ("line constraints")
     ("box constraints" )
     ("c32")
     ))
   ("other"   nil  (
     ("clear workspace")  ; new
     ("interactors")
     )) )))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; radio button
(defun LapRadioFun (gadget button)
  (cond
   ((equal button "build")
    ;; make any windows that were made invisible during run mode
    ;; visible again
    (dolist (win (g-value *selection-info* :visible-windows))
      (when (not (g-value win :visible))
        (s-value win :visible t)))
    (s-value *selection-info* :visible-windows nil)
    (s-value editor-menu :build-p t))
   ((equal button "test")
    ;; make a list of visible windows
    (dolist (win (g-value *selection-info* :window))
     (when (g-value win :visible)
      (push win (g-value *selection-info* :visible-windows))))
    (deselect-objects)
    (s-value editor-menu :build-p nil))))

(create-instance 'RADIO garnet-gadgets:radio-button-panel
 (:direction :horizontal)
 (:selection-function #'LapRadioFun)
 (:top (o-formula (- (gvl :window :height) (gvl :height) 5)))
 (:left (o-formula (round (- (gvl :window :width) (gvl :width)) 2)))
 (:items '("run" "build")))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; window
(create-instance 'WIN inter:interactor-window
 (:top 80)
 (:left 750)
 (:width (g-value LAP-MENU :width))
 (:height 200)
 (:title "Lapidary Menu"))

(create-instance 'TOP-AGG opal:aggregate)
(s-value WIN :aggregate TOP-AGG)
(opal:update WIN)

(opal:add-component TOP-AGG LAP-MENU)
(opal:notice-items-changed LAP-MENU)
(opal:add-component TOP-AGG RADIO)
(opal:update WIN)

; (opal:destroy lapidary::WIN)
; (opal:destroy WIN)
; (load "debug")
; (load "debug2")
; (inter:main-event-loop)

(opal:kill-main-event-loop-process)   ;; does nothing if process wasn't
                                              ;; running in first place.
(inter:main-event-loop)
