;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;

(in-package "LAPIDARY" :use '("LISP" "KR"))

(create-instance 'parameter-menu OPAL:AGGREGADGET
  (:WINDOW-TITLE "Parameters")
  (:WINDOW-LEFT 0)
  (:WINDOW-TOP 0)
  (:WINDOW-WIDTH (o-formula (+ 20 (gvl :width))))
  (:WINDOW-HEIGHT (o-formula (+ 20 (gvl :height))))
  (:PACKAGE-NAME "LAPIDARY")
  (:items nil)
  (:FUNCTION-FOR-OK `create-parameters)
  (:LEFT 0)
  (:TOP 0)
  (:parts `(
    (:OKCANCEL-BUTTON ,GARNET-GADGETS:TEXT-BUTTON-PANEL
      (:SELECTION-FUNCTION OKCANCEL-FUNCTION)
      (:INDENT 0)
      (:V-ALIGN :TOP)
      (:V-SPACING 5)
      (:H-ALIGN :CENTER)
      (:FIXED-HEIGHT-P T)
      (:H-SPACING 5)
      (:PIXEL-MARGIN NIL)
      (:RANK-MARGIN NIL)
      (:FIXED-WIDTH-P T)
      (:SELECT-FUNCTION OKCANCEL-FUNCTION)
      (:ITEMS ("OK" "Cancel" ))
      (:GRAY-WIDTH 3)
      (:FINAL-FEEDBACK-P NIL)
      (:TEXT-OFFSET 2)
      (:SHADOW-OFFSET 5)
      (:DIRECTION :HORIZONTAL)
      (:LEFT 80)
      (:top ,(o-formula (+ (opal:gv-bottom (if (gvl :parent :ptr-items)
					       (gvl :parent :ptr-slots)
					       (gvl :parent :slots)))
			   20))))

    (:label ,opal:multi-text
      (:left 10)
      (:top 10)
      (:string "Select the slots which should be parameters. Then in the
text boxes, enter the name of the slots in the secondary 
selection that the slots should retrieve their values from"))
    (:slots ,garnet-gadgets:x-button-panel
      (:left 10)
      (:top ,(o-formula (+ (opal:gv-bottom (gvl :parent :label)) 20)))
      (:items ,(o-formula (gvl :parent :items))))
    (:parameters ,opal:aggrelist
      (:left ,(o-formula (+ (opal:gv-right (gvl :parent :slots)) 10)))
      (:top ,(o-formula (+ (gvl :parent :slots :top) 2)))
      (:items ,(o-formula (gvl :parent :items)))
      (:v-spacing 13)
      (:item-prototype 
       (,garnet-gadgets:labeled-box
	(:label-string "")
	(:value ,(o-formula (prin1-to-string (nth (gvl :rank) 
						  (gvl :parent :items))))))))
    (:instructions ,opal:multi-text
      (:left 10)
      (:top ,(o-formula (+ (opal:gv-bottom (gvl :parent :parameters)) 20)))
      (:string "The following slots reference objects that might be 
parameters. Select those slots that reference parameter
objects. Next to those slots, enter the name of the slot
in the secondary selection that will point to the parameter
object.")
      (:visible ,(o-formula (gvl :parent :ptr-items))))
    (:ptr-slots ,garnet-gadgets:x-button-panel
      (:left 10)
      (:top ,(o-formula (+ (opal:gv-bottom (gvl :parent :instructions)) 20)))
      (:items ,(o-formula (gvl :parent :ptr-items)))
      (:visible ,(o-formula (gvl :items))))
    (:ptr-parameters ,opal:aggrelist
      (:left ,(o-formula (+ (opal:gv-right (gvl :parent :ptr-slots)) 10)))
      (:top ,(o-formula (+ (gvl :parent :ptr-slots :top) 2)))
      (:items ,(o-formula (gvl :parent :ptr-names)))
      (:visible ,(o-formula (gvl :items)))
      (:v-spacing 13)
      (:item-prototype 
       (,garnet-gadgets:labeled-box
	(:label-string "")
	(:value ,(o-formula (prin1-to-string (nth (gvl :rank) 
						  (gvl :parent :items))))))))
)))



(define-method :notice-items-changed parameter-menu
               (gadget &optional no-propagation)
  (declare (ignore no-propagation))
  (opal:notice-items-changed (g-value gadget :slots))
  (opal:notice-items-changed (g-value gadget :parameters))
  (opal:notice-items-changed (g-value gadget :ptr-slots))
  (opal:notice-items-changed (g-value gadget :ptr-parameters))
)

;;; make sure the :value slots of parameter menu are demanded so that
;;; their formulas are not wiped out
(g-value parameter-menu :slots :value)
(g-value parameter-menu :ptr-slots :value)

(s-value opal:graphical-object :lapidary-parameters 
	 '(:filling-style :line-style :draw-function))

(s-value opal:text :lapidary-parameters	
	 '(:font :string :line-style :draw-function))

(s-value opal:line :lapidary-parameters
	 '(:line-style :draw-function))

(s-value garnet-gadgets:arrow-line :lapidary-parameters
	 '(:line-style :draw-function :filling-style))

(s-value garnet-gadgets:double-arrow-line :lapidary-parameters
	 '(:line-style :draw-function :filling-style))

(s-value opal:aggrelist :lapidary-parameters
	 '(:filling-style :line-style :draw-function :select-function 
				:direction
				:v-spacing :h-spacing
				:fixed-width-size
				:fixed-height-size
				:fixed-width-p :fixed-height-p
				:h-align :v-align 
				:rank-margin :pixel-margin 
				:indent))

(defun map-slot-to-link (slot)
  (second (assoc slot '((:left :left-over) (:top :top-over) 
			(:width :width-over) (:height :height-over)
			(:x1 :x1-over) (:y1 :y1-over)
			(:x2 :x2-over) (:y2 :y2-over)))))

(defun create-parameters (gadget values)
  (declare (special *selection-info*))
  (let* ((slots (gilt:value-of :slots values))
	 (ptr-slots (gilt:value-of :ptr-slots values))
	 (p-selected (car (g-value *selection-info* :p-selected)))
	 (s-selected (car (g-value *selection-info* :s-selected)))
	 (path (make-path p-selected s-selected))
	 parameter-slot)
    (dolist (slot slots)
      (setf parameter-slot 
	    (read-from-string
	     (g-value (nth (position slot (g-value gadget :items))
			   (g-value gadget :parameters :components))
		      :value)))
      ;; copy the value of the primary selection into the secondary
      ;; selection 
      (s-value s-selected parameter-slot (g-value p-selected slot))
      (s-value p-selected slot 
	       (formula `(gvl ,@path ,parameter-slot))))

    (dolist (slot ptr-slots)
      (setf parameter-slot 
	    (read-from-string
	     (g-value (nth (position slot (g-value gadget :ptr-items))
			   (g-value gadget :ptr-parameters :components))
		      :value)))
      ;; copy the value of the primary selection into the secondary
      ;; selection 
      (s-value s-selected parameter-slot 
	       (g-value p-selected (map-slot-to-link slot)))
      (s-value p-selected (map-slot-to-link slot)
	       (formula `(gvl ,@path ,parameter-slot))))
))

(defun show-parameter-window (gadget)
  (declare (special parameter-menu))
  (let ((p-selected (car (g-value *selection-info* :p-selected)))
	(s-selected (car (g-value *selection-info* :s-selected)))
	symbol-table ptr-items link-slot link-value)
    (when (null s-selected)
	  (lapidary-error "Must use a secondary selection to select the 
object which provides the parameter values")
	  (return-from show-parameter-window))
    (when (null p-selected)
	  (lapidary-error "Must use a primary selection to select the 
object which should be parameterized")
	  (return-from show-parameter-window))

    ;; set the normal parameters such as filling-style and line-style
    (s-value parameter-menu :items (g-value p-selected :lapidary-parameters))
    (s-value (g-value parameter-menu :slots) :value nil)

    ;; determine which position slots might require parameters
    (setf symbol-table (transitive-closure s-selected))
    (dolist (slot (if (is-a-line-p p-selected)
		      '(:x1 :y1 :x2 :y2)
		      '(:left :top :width :height)))
      (setf link-slot (map-slot-to-link slot))
      (setf link-value (get-value p-selected link-slot))
      (when (and link-value
		 (not (formula-p link-value))
		 (not (member link-value symbol-table)))
	    (push slot ptr-items)))
    (s-value parameter-menu :ptr-items (reverse ptr-items))
    (s-value (g-value parameter-menu :ptr-slots) :value nil)
    (opal:notice-items-changed parameter-menu)
    (gilt:show-in-window parameter-menu 300 100)))