/*$Header: /a/lewis/disk/home/lfcs1/rjg/Ml/fam.src/UPTODATE/RCS/fam.c,v 4.7 90/12/20 15:27:55 rjg Exp $*/

#include <stdio.h>
#include "globdefs.h"
#include "structs.h"
#include "globvars.h"
#include "debug.h"
#include "io.h"

FatalError(errorText)
char *errorText;
{ fprintf(stderr, "\nFatal Error: %s\n", errorText);
  perror("");  exit(1); }

main(argc,argv)
int argc; char *argv[];
{  int     i;  int noisy = 1; int recon = 0; int flushing = 1;
   char *bootfile;
   char ProgArg[80];  /* It is intended that this string will eventually
                         be passed to the saved state as an argument */

/* for some reason there are lots of these calls for the risc_os port */
#ifdef RISC_OS
   SetupIntHandler();
#endif
   i = 1;
   while (i < argc && argv[i][0] == '-')
      switch (argv[i++][1]) {

      case 'h': if (i == argc) break;
                if (sscanf(argv[i++], "%d", &HeapSize) != 1  ||
                    HeapSize >= 32*1024)
                   FatalError("-h <heapsize in kbytes> expected");
                HeapSize *= 1024;
                break;
      case 's': break;               /* System builder */
      case 'q': noisy = 0; break;    /* Suppresses initial messages */
      case 'b': flushing = 0; break; /* disables effect of famflush() */
      case 'r': recon = 1; break;    /* Allows heap reconfiguration */
      /*
       * The next (-p) flag allows running down pipes to collect scripts...
       *
       * Sam Nelson, Stirling Univ., 20.1.88.
       */
      case 'p':
	faketty=1;
	setbuf(stdout,NULL); break;
#ifdef DEBUGinterp
      case 'o': strcpy(OpNameFile,argv[i++]) ; break ;
      default:
         FatalError("fam [-q] [-p] [-h n] [-o file] bootfile [args] expected") ;
#else
      default:
         FatalError("fam [-q] [-p] [-h n] bootfile [args] expected");
#endif
      }

#ifdef RISC_OS
   SetupIntHandler();
   SetupIntHandler();
#endif
   if (i < argc) bootfile = argv[i++];
   else FatalError("fam [-q] [-p] [-h n] bootfile [args] expected");

   ProgArg[0] = 0; if (i < argc) strcpy(ProgArg, argv[i++]);
   for (; i < argc; i++) {strcat(ProgArg, " "); strcat(ProgArg, argv[i]);}

   if (noisy)
      printf ("FAM %s started on %s \n   (version %s%s of %s)\n",
              argv[0], datestring(DateInUnix()),
              verstring(VERSION), SUBVERSION, filecreationdate(argv[0]));

   CreateInitialHeapSpace();
   CurrentState = (State *)ImportState(bootfile, noisy, recon);

   Seed = TodInS() & 0x7fff;

   SetupStreams(flushing);
#ifdef READLINE
   SetupReadline(argv[0]);
#endif
   SetupExceptions();
   ResetConstants();
   SetTopProcess();
   SetupIntHandler();
   RunState();
}

