(* Dynamic values and objects for the Modules (Defn. V4 p57). *)

(*
$File: $
$Date: 1992/01/29 15:11:07 $
$Revision: 1.2 $
$Locker:  $
*)

(*$MODULE_DYNOBJECT: DYNAMIC_BASIS*)

signature MODULE_DYNOBJECT =
  sig
    include DYNAMIC_BASIS		(* The Interpreter's Module DynObject
					   module must match the generic
					   Dynamic Basis interface. *)
   (* imported types: *)
    type strid and longstrid
    type sigid
    type funid
    type strexp
    eqtype var
    eqtype excon
    type Env
    type StrEnv

    type ('a, 'b) map

   (* Defined types. (Which go under a lot of the same names as the static
      objects, just to cause confusion. Don't blame me, I didn't write
      the semantics.) : *)

    type FunctorClosure
    type Int
    type IntEnv
    type SigEnv
    type FunEnv
    type IntBasis

    val InterE: Env -> Int		(* Interface extraction. *)
    val InterB: Basis -> IntBasis	(* ditto. *)
    val Cut: Env * Int -> Env		(* Environment restriction. *)

    val Vars_in_Int: var EqSet.Set -> Int
    val Excons_in_Int: excon EqSet.Set -> Int
    val IE_in_Int: IntEnv -> Int
    val IE_of_Int: Int -> IntEnv
    val singleIE: strid * Int -> IntEnv
    val IE_plus_IE: IntEnv * IntEnv -> IntEnv
    val emptyInt: Int
    val Int_plus_Int: Int * Int -> Int
    val emptyG: SigEnv
    val singleG: sigid * Int -> SigEnv
    val G_plus_G: SigEnv * SigEnv -> SigEnv
    val G_of_IB: IntBasis -> SigEnv
    val G_in_IB: SigEnv -> IntBasis
    val G_in_B: SigEnv -> Basis
    val IB_plus_G: IntBasis * SigEnv -> IntBasis
    val IB_plus_IE: IntBasis * IntEnv -> IntBasis
    val emptyF: FunEnv
    val singleF: funid * FunctorClosure -> FunEnv
    val F_plus_F: FunEnv * FunEnv -> FunEnv
    val F_in_B: FunEnv -> Basis
    val F_of_B: Basis -> FunEnv
    val B_plus_F: Basis * FunEnv -> Basis
    val E_in_B: Env -> Basis
    val E_of_B: Basis -> Env
    val B_plus_E: Basis * Env -> Basis
    val lookup_SigId: SigEnv * sigid -> Int
    val lookup_LongStrId_B: Basis * longstrid -> Env
    val lookup_LongStrId_IB: IntBasis * longstrid -> Int
    val lookup_FunId: FunEnv * funid -> FunctorClosure

    val B_plus_SE: Basis * StrEnv -> Basis
			(* It's only at the modules level that we get the notion
			   of basis, so we can't do this in CoreDynObject. *)

    val mkClosure:
      (strid * Int) * (strexp * Int Option) * Basis -> FunctorClosure

    val unClosure:
      FunctorClosure -> (strid * Int) * (strexp * Int Option) * Basis

    type StringTree
    val layoutInt: Int -> StringTree
    val layoutBasis: Basis -> StringTree

    type Report
    val reportBasis: Basis -> Report
  end;
