signature Pair =
sig

(* PAIRS

   Created by:	Dave Berry, LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:	4 Oct 1989

   Maintenance: Author


   DESCRIPTION

   Functions on the built-in type ('a * 'b).

   The usual comparison operators are omitted, because they're all the
   same as binary (or binaryPair).  For example,
     fun lt Int.lt (x, y) (x', y') = binary Int.lt (x, y) (x', y').


   SEE ALSO

   ListPair
*)


  val version: real
   (* version = 0.1 *)


(* CREATORS *)

  val create: 'a -> 'b -> ('a * 'b)
   (* create x y; yields (x, y). *)


(* CONVERTORS *)

  val string: ('a -> string) -> ('b -> string) -> ('a * 'b) -> string

  val parse: (string list -> ('a * string list, 'c) Result) ->
  	     (string list -> ('b * string list, 'c) Result) ->
	     string -> ('a * 'b, unit) Result

  val parse': (string list -> ('a * string list, 'c) Result) ->
  	      (string list -> ('b * string list, 'c) Result) ->
	      string list -> (('a * 'b) * string list, unit) Result

  val read: (InStream -> ('a, 'c) Result) ->
	    (InStream -> ('b, 'c) Result) ->
	    InStream -> ('a * 'b, unit) Result


(* MANIPULATORS *)

   val swap: ('a * 'b) -> ('b * 'a)
    (* swap (x, y); returns (y, x). *)

   val apply: ('a -> 'b) -> ('a * 'a) -> ('b * 'b)
    (* apply f (x,y); yields (f x, f y). *)

   val applyPair: ('a -> 'b) * ('c -> 'd) -> ('a * 'c) -> ('b * 'd)
    (* applyPair (f, g) (x, y); yields (f x, g y). *)

   val binary: ('a -> 'b -> 'c) -> ('a * 'a) -> ('b * 'b) -> ('c * 'c)
    (* binary f (x, y) (x', y'); yields (f x x', f y y'). *)

   val binaryPair: ('a -> 'b -> 'c) * ('d -> 'e -> 'f) ->
			('a * 'd) -> ('b * 'e) -> ('c * 'f)
    (* binaryPair (f, g) (x, y) (x', y'); yields (f x x', g y y'). *)

   val tee: ('a -> 'b) * ('a -> 'c) -> 'a -> ('b * 'c)
    (* tee f (x, y); yields (f x, f y). *)

end
