signature StringType =
sig

(* CHARACTER CLASSES

   Created by:	Dave Berry, LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:        4 Oct 1989

   Maintenance:	Author


   DESCRIPTION

   Functions to find the types of the first character in a string.


   NOTES

   The name of ASCII character 26 is really "sub", but that clashes with the
   subscript function used in String (which includes StringType).  I've called
   it "sb".
*)

  val version: real
   (* version = 0.1 *)


(* CONSTANTS *)

  val digits: string
   (* digits = "1234567890"; *)
  val hexes: string
   (* hexes = "1234567890abcdefABCDEF"; *)
  val formats: string
   (* formats; contains space, tab, newline, carriage return, backspace,
      and formfeed *)
  val uppers: string
   (* uppers = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"; *)
  val lowers: string
   (* lowers = "abcdefghijklmnopqrstuvwxyz"; *)
  val letters: string
   (* letters = uppers ^ lowers; *)
  val alNums: string
   (* alNums = letters ^ digits; *)
  val ids: string
   (* ids = alNums ^ "_'"; *)
  val symbols: string
   (* symbols = "!%&$#+-/:<=>?@\\~`^|*"; *)
  val puncts: string
   (* puncts = symbols ^ "'_(),.;[]{}"; *)
  val visibles: string
   (* visibles = letters ^ digits ^ puncts *)
  val prints: string
   (* prints = visibles ^ formats *)
  val controls: string
   (* controls; the control characters (Ascii numbers 0 - 31 and 127) *)
  val asciis: string
   (* asciis = controls ^ visibles *)

  val nul: string
   (* nul = "\000" *)
  val soh: string
   (* soh = "\001" *)
  val stx: string
   (* stx = "\002" *)
  val etx: string
   (* etx = "\003" *)
  val eot: string
   (* eot = "\004" *)
  val enq: string
   (* enq = "\005" *)
  val ack: string
   (* ack = "\006" *)
  val bel: string
   (* bel = "\007" *)
  val bs: string
   (* bs = "\008" *)
  val ht: string
   (* ht = "\009" *)
  val nl: string
   (* nl = "\010" *)
  val vt: string
   (* vt = "\011" *)
  val np: string
   (* np = "\012" *)
  val cr: string
   (* cr = "\013" *)
  val so: string
   (* so = "\014" *)
  val si: string
   (* si = "\015" *)
  val dle: string
   (* dle = "\016" *)
  val dc1: string
   (* dc1 = "\017" *)
  val dc2: string
   (* dc2 = "\018" *)
  val dc3: string
   (* dc3 = "\019" *)
  val dc4: string
   (* dc4 = "\020" *)
  val nak: string
   (* nak = "\021" *)
  val syn: string
   (* syn = "\022" *)
  val etb: string
   (* etb = "\023" *)
  val can: string
   (* can = "\024" *)
  val em: string
   (* em = "\025" *)
  val sb: string
   (* sb = "\026".  This should really be "sub" - see NOTES. *)
  val esc: string
   (* esc = "\027" *)
  val fs: string
   (* fs = "\028" *)
  val gs: string
   (* gs = "\029" *)
  val rs: string
   (* rs = "\030" *)
  val us: string
   (* us = "\031" *)
  val del: string
   (* del = "\127" *)


(* OBSERVERS *)

  (* These functions tests the first character of a string for membership
     of the above sets.  They raise Empty if the string is empty. *)

  exception Empty of string
   (* Empty fn; raised if the function called fn is applied to an empty
      string. *)

  val isDigit: string -> bool
  val isHex: string -> bool
  val isFormat: string -> bool
  val isPrint: string -> bool
  val isVisible: string -> bool
  val isLetter: string -> bool
  val isUpper: string -> bool
  val isLower: string -> bool
  val isPunct: string -> bool
  val isControl: string -> bool
  val isAlNum: string -> bool
  val isId: string -> bool
  val isSymbol: string -> bool
  val isAscii: string -> bool

end
