(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: WordModule.m3                                         *)
(* Last Modified On Sat Jun  1 00:08:32 1991 By kalsow         *)
(*      Modified On Thu Jul 27 17:10:39 1989 By muller         *)

MODULE WordModule;

IMPORT Scope, Tipe, Module, Int, IntegerExpr, Constant, Target, NamedType;
IMPORT WordPlus, WordMinus, WordTimes, WordLT, WordLE, WordGT, WordGE;
IMPORT WordAnd, WordOr, WordXor, WordShift, WordRotate, WordExtract;
IMPORT WordInsert, WordNot, WordDivide, WordMod;

PROCEDURE Initialize () =
  VAR zz: Scope.T;
  BEGIN
    M := Module.NewDefn ("Word", TRUE);
    zz := Scope.Push (Module.ExportScope (M));
    Tipe.Define ("T", NamedType.New (Int.T), FALSE);
    Constant.Declare ("Size", IntegerExpr.New (Target.INTSIZE), FALSE);
    WordPlus.Initialize ();
    WordMinus.Initialize ();
    WordTimes.Initialize ();
    WordDivide.Initialize ();
    WordMod.Initialize ();
    WordLT.Initialize ();
    WordLE.Initialize ();
    WordGT.Initialize ();
    WordGE.Initialize ();
    WordAnd.Initialize ();
    WordOr.Initialize ();
    WordXor.Initialize ();
    WordNot.Initialize ();
    WordShift.Initialize ();
    WordRotate.Initialize ();
    WordExtract.Initialize ();
    WordInsert.Initialize ();
    Scope.Pop (zz);
  END Initialize;

BEGIN
END WordModule.
