(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: OpenArrayType.i3                                      *)
(* Last Modified On Mon Mar  2 10:21:31 PST 1992 By kalsow     *)
(*      Modified On Sat Nov 10 01:11:37 1990 By muller         *)

INTERFACE OpenArrayType;

IMPORT Type;

PROCEDURE New (element: Type.T): Type.T;

PROCEDURE Is (t: Type.T): BOOLEAN;
(* Return TRUE iff 't' is an open array type *)

PROCEDURE Split (t: Type.T;  VAR element: Type.T): BOOLEAN;
(* If 't' is an open array type, returns TRUE and sets 'element'
   to the appropriate type.  Otherwise, returns FALSE *)

PROCEDURE OpenDepth (t: Type.T): INTEGER;
(* If 't' is an n-dimensional open array, returns n else returns 0 *)

PROCEDURE OpenType (t: Type.T): Type.T;
(* If 't' is an n-dimensional open array, returns the type of the base
   elements; otherwise, returns t. That is, strip all the ARRAY OF in 
   front of t *)

END OpenArrayType.
