(* Copyright (C) 1990, Digital Equipment Corporation.         *)
(* All rights reserved.                                       *)
(* See the file COPYRIGHT for a full description.             *)

(* Last modified on Fri Jun 21 23:05:57 1991 by muller        *)


INTERFACE Atom;

(* An Atom.T is like a TEXT, except that atoms with the same characters 
   are equal as references.   This is achieved by maintaining a 
   hash table internal to the implementation, mapping the text name 
   of the atom to the unique reference that represents it.  
   
   Atoms can be pickled.  *)

IMPORT Property;

TYPE T <: Property.Set;

PROCEDURE New (n: TEXT): T;
  (* Return the atom with name n. *)

PROCEDURE NewFromChars (READONLY a: ARRAY OF CHAR): T;
  (* Return the atom with name s; equivalent to
     New (Text.FromChars (a)); *)

PROCEDURE Name (a: T): TEXT;
  (* Return the name of the atom a.  Results of successive calls on 
     the same atom will be =, not just Text.Equal. *) 

END Atom.
