(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Tue Sep  8 11:51:46 PDT 1992 by jdd        *)
(*      modified on Thu Mar 12 12:10:27 PST 1992 by muller     *)
(*      modified on Thu Jan 30 14:07:47 PST 1992 by kalsow     *)

INTERFACE RT0;

(* This interface is "the bottom of the world".  It contains
   types and constants that are shared by multiple modules of
   the runtime and/or the compiler and linker.

   If you're using this interface, you're a wizard!

   This interface and its implemenation MUST NOT import any
   other interface.
*)

(*------------------------------------ compiler generated data structures ---*)

(* These types CANNOT be changed without a synchronized change to the
   output of the compiler *)

TYPE
  Typecode    = [0 .. 16_FFFFF];     (* can fit in 20 bits *)
  Fingerprint = ARRAY [0..1] OF INTEGER;
  String      = UNTRACED REF CHAR;    (* a '\000' terminated string *)
  IntList     = UNTRACED REF INTEGER;

TYPE (* one of these is generated for each compilation unit *)
  ModuleInfo = UNTRACED REF RECORD
    file         : String;
    type_info    : TypeInfoList;
    type_fp_data : IntList;
    type_cells   : TypeCellList;
    revelations  : Revelations;
    proc_info    : ProcInfoList;
    init         : PROCEDURE ();
    map          : ModuleMapProc;
  END;

TYPE
  TypeInfoList    = UNTRACED REF TypeInfo;
  TypeCellList    = UNTRACED REF TypeDefinition;
  ProcInfoList    = UNTRACED REF ProcInfo;
  Revelations     = RECORD exported, imported: RevelationSet END;
  RevelationSet   = RECORD full, partial: RevelationPairs END;
  RevelationPairs = UNTRACED REF RevelationPair;

TYPE (* one of these is generated for each top-level procedure *)
  ProcInfo = RECORD
    proc   : ADDRESS;
    typeID : INTEGER;
    name   : String;
    fp     : Fingerprint;
  END;

TYPE (* one of these is generated for each type definition *)
  TypeInfo = RECORD
    id     : INTEGER;
    fp     : Fingerprint;
    data   : IntList; (* if class = Opaque => TypeDefinitionPtr *)
    d_len  : INTEGER;
    seq    : INTEGER;
    class  : INTEGER;
  END;

TYPE
  TypeClass = { None, Array, Enum, Object, Opaque, OpenArray, Packed,
                Procedure, Record, Ref, Set, Subrange };

TYPE
  RevelationPair = RECORD
    lhs, rhs       : TypeDefinitionPtr;
    lhs_id, rhs_id : INTEGER;
  END;

TYPE
  MethodSuite = UNTRACED REF RECORD
    typecode : Typecode;
    methods  : ARRAY [0..999999] OF ADDRESS;
  END;

  TypeDefinition = UNTRACED REF Typecell;
  TypeDefinitionPtr = UNTRACED REF TypeDefinition;

  Typecell = RECORD
    typecode         : Typecode;
    lastSubTypeTC    : Typecode;
    selfID           : INTEGER;
    selfLink         : TypeDefinitionPtr;
    fpInfo           : ADDRESS; (* reserved for RTTypeFP *)
    traced           : BOOLEAN;

    dataOffset       : INTEGER;
        (* for object types, the quantity to add to the address of the object
             to get to the fields that belong to this object type;
           for refs, unused;
           for open arrays, the quantity to add to the address of the array
             to get to the elements *)
    dataSize         : INTEGER;
        (* for object types, the size of the fields that belong to this
             object type;
           for refs, the size of the referent;
           for open array types, the size of the "open overhead", including
             padding to align the elements; i.e. ADR (a[0]) - ADR (a) *)
    dataAlignment    : INTEGER;
        (* for object types, the alignment constraint for the fields that
             belong to this object type;
           for refs, the alignment of the referent;
           for open arrays, the alignment of the full array, including
             the header *)

    methodOffset     : INTEGER;
    methodSize       : INTEGER;
    nDimensions      : INTEGER; (* > 0 iff open array *)
    elementSize      : INTEGER;
    defaultMethods   : ADDRESS; (* # NIL iff object type *)
    setupProc        : TypeSetupProc; (* called by RTMisc.Run *)
    mapProc          : TypeMapProc;   (* called by RTType.Visit *)
    initProc         : TypeInitProc;  (* called by NEW *)
    brand            : String;
    name             : String;
    parentLink       : TypeDefinitionPtr;
    parent           : TypeDefinition;
    children         : TypeDefinition;
    sibling          : TypeDefinition;
  END;

TYPE
  RefType    = { Traced, Untraced, Proc };
  RefTypeSet = SET OF RefType;

TYPE  (* NOTE: VisitProcs must be top-level procedures *)
  VisitProc  = PROCEDURE (arg   : REFANY;
                          field : ADDRESS;
                          base  : ADDRESS;
                          type  : RefType) RAISES ANY;

TYPE
  ModuleMapProc = PROCEDURE (visit : VisitProc;
                             arg   : REFANY;
                             mask  : RefTypeSet);

  TypeMapProc = PROCEDURE (visit : VisitProc;
                           arg   : REFANY;
                           ref   : ADDRESS;
                           mask  : RefTypeSet);

  TypeInitProc  = PROCEDURE (ref: ADDRESS);
  TypeSetupProc = PROCEDURE (def: TypeDefinition);

(*----------------------------------------- compiler generated references ---*)

CONST
  NilTypecode  : Typecode = 0;
  TextTypecode : Typecode = 1;

TYPE
  RefHeader =
    RECORD
      forwarded: BITS 1 FOR BOOLEAN := FALSE; (* used during collection *)
      typecode: BITS 20 FOR Typecode;  (* the typecode *)
      weak    : BITS 1 FOR BOOLEAN     := FALSE; (* any weakrefs? *)
      marka: BITS 1 FOR BOOLEAN  := FALSE; (* used during collection *)
      markb: BITS 1 FOR BOOLEAN  := FALSE; (* used during collection *)
      spare: BITS 8 FOR [0 .. 0] := 0; (* for future expansion *)
    END;

END RT0.
