(* File: NameMap.i3
|
| Fri Nov  6 16:30:21 MET 1992 by preschern
| Rewritten by Carsten Weich, July 1993

NameMap maps long unix filenames to shorter DOS filenames (max. 8 characters,
a dot and max. 3 characters "extension").


The Mapfile

There is a global mapfile which does the translation. It looks like
|    DOS-filename     <TAB>     Unixfilename   <EOL>
<EOL> may be '\n' or "\n\r".

If a unixfilename is shorter than 8 characters or contains a single dot and
has not more than 8 charaters befor and 3 characters after it, there will be
no entry in the mapfile. The corresponding DOS filename then is simply
the same with no upper/lowercase distinguision.

The DOS-filename will always contain a NameMap.DollarChar (usually $)
so mapped names can be figured out in the directory.


Construction of the DOS-name:

If the long name has an extension shorter than 4 characters, a $ will
be inserted after the 7th character and the unchanged extension will
be appended:   VeryLongName.ext  -> verylon$.ext

Any Dot not belonging to the last extension will be replaced by a dollar:
				name.with.more.dots.ext  ->  name$wi$.ext
If a name only consits of an extension there will be no extension in the
DOS name:		.imports  ->  $import$
				.pgms     ->  $pgms--$
Names are always filled up (with '-' chars) such that the last position
of the first part of the name is a $.

Extensions longer than 3 characters are cut off and the third character
will be a $:	name.longext  -> name---$.lo$

If a name constructed with those rules is unambiguous, the $ is moved
to the 7th position and a '1' is appended:
				VeryLongOtherName.ext -> verylo$1.ext
				name.longotherext     -> name--$1.lo$

If this again is a already used name, the '1' is replaced by a '2' and
so forth. After '9' a 'a' is used. The last possibility is '$z'. If
this still is unambigous -- bad luck: ASSERT FAILED will be the result...


Errors

Any fileio-errors during manipulation of the mapfile are passed through as
an exception. There a number of consisty checks made when manipulating
the maps. Use RdUtils.FailureText() to get an error-message.
****************************************************************)

INTERFACE NameMap;

IMPORT Rd, Wr;

CONST MapFile = "/m3/lib/filename.map";
    DollarChar = '$';

PROCEDURE IsDosStyle(name: TEXT): BOOLEAN;
    (* Returns TRUE if name is a valid DOS filename within the meaning
       of this module *)

PROCEDURE Add (name: TEXT) RAISES {Wr.Failure};
    (* Put name to the mapfile. Directoryinformations are stripped from
       'name' before it is added. This is a no-op if name is shorter than 8
        characters or 8.3 characters like a DOS filename. 
        Directorypath-informations are thrown away before the name is added. *)

PROCEDURE Remove (name: TEXT) RAISES {Wr.Failure};
    (* Remove a mapping from the mapfile. 'name' is a long filename. 
       This is a no-op when called with a valid dos-name or if no
       'name' is found in the mapfile. *)

PROCEDURE GetDos (name: TEXT; add:= FALSE): TEXT RAISES {Rd.Failure};
    (* You have a long 'name' and want a DOS name.
        If there is no entry in the mapfile then it is added if add is TRUE,
        otherwise 'name' is returned unchanged.
        Any directory-path will be preserved by the call. *)

PROCEDURE GetLong (name: TEXT): TEXT RAISES {Rd.Failure};
    (* You have a DOS name and want a Unix name. If there is no such
       name in the mapfile, name is returned unchanged.
        Any directory-path will be preserved by the call. *)

PROCEDURE RereadNameMap() RAISES {Rd.Failure};
    (* Normally the mapfile is actualised automatically, so this procedure
       is rarely needed. But if you call a programm that might change
       the mapfile you should call this to make the changes visible in the
       calling program (otherwise the caller might destroy the changes
       by newly writing the mapfile or may not be able to access newly
       created files from the called programm) *)

END NameMap.

