
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

% Fix code containing illegal (excess) temporary variables,
% those temporaries numbered X9 or higher.

% Excess phase contains three passes:
%	1.  Backwards pass to reallocate permanents and excess temporaries
% 	    as permanents.  As in permalloc, variables whose last use
%	    is later in the program get lower numbered locations.
%	2.  Forward pass to fix up all get and put instructions whose
%	    second operand is now a permanent.
%	3.  Forward pass to change the 'unsafe_value' annotation to a
%	    'value' annotation for all temporaries.  This finishes the
%	    work started by valvar.

excess(Objcode,Objcode4) :-
   excess(Objcode,Objcode2,_,_),
   cleanup(Objcode2,Objcode3),
   temp_value(Objcode3,Objcode4).

% Pass 1.

excess([I|Rest],[NI|NR],NewPerm,NewMap) :-
   excess(Rest,NR,NextPerm,Map),
   fix_excess(I,NI,NextPerm,NewPerm,Map,NewMap).

excess([],[],1,[]).

fix_excess(get(Ann,A,B),get(Ann,NA,NB),NextPerm,NewPerm,Map,NewMap) :-
   fix_temp(A,NA,NextPerm,NextPerm2,Map,NextMap),
   fix_temp(B,NB,NextPerm2,NewPerm,NextMap,NewMap).

fix_excess(put(Ann,A,B),put(Ann,NA,NB),NextPerm,NewPerm,Map,NewMap) :-
   fix_temp(A,NA,NextPerm,NextPerm2,Map,NextMap),
   fix_temp(B,NB,NextPerm2,NewPerm,NextMap,NewMap).

fix_excess(unify(Ann,A),unify(Ann,NA),NextPerm,NewPerm,Map,NewMap) :-
   fix_temp(A,NA,NextPerm,NewPerm,Map,NewMap).

fix_excess(I,I,NextPerm,NextPerm,Map,Map).

% allocate a new permanent in place of old permanent or excess temporary.

fix_temp(A,NA,NextPerm,NewPerm,Map,NewMap) :-
   nonvar(A), A=x(I), nonvar(I), I>8, !, 
   add_perm(A,NA,NextPerm,NewPerm,Map,NewMap).

fix_temp(A,NA,NextPerm,NewPerm,Map,NewMap) :-
   nonvar(A), A=y(_), !, 
   add_perm(A,NA,NextPerm,NewPerm,Map,NewMap).

fix_temp(A,A,NextPerm,NextPerm,Map,Map).

	add_perm(A,NA,NextPerm,NewPerm,Map,NewMap) :-
		inmap(A,Map,NA), !,
		NewMap = Map, NewPerm = NextPerm.
	add_perm(A,NA,NextPerm,NewPerm,Map,NewMap) :-
		NA = y(NextPerm),
		NewPerm is NextPerm+1,
		NewMap = [pair(A,NA)|Map].

% check whether variable has been reallocated yet, and if so, what it has been
% reallocated to.

inmap(A,[pair(A,NA)|_],NA) :- !.
inmap(A,[_|Rest],NA) :- inmap(A,Rest,NA), !.

% Pass 2.

cleanup([put(Ann,A,B),get(structure,S,C)|Rest],
	[put(Ann,A,x(8)),get(structure,S,x(8))|NRest]) :-
   nonvar(A), nonvar(B), nonvar(C), A = y(_), A = B, B = C, !,
   cleanup(Rest,NRest).

cleanup([put(Ann,A,B)|Rest],
	[put(value,B,x(8)),put(structure,A,x(8))|NRest]) :-
   nonvar(Ann), Ann = structure, nonvar(B), B = y(_), !, 
   cleanup(Rest,NRest).

cleanup([put(Ann,A,B)|Rest],
	[put(Ann,A,x(8)),get(variable,B,x(8))|NRest]) :-
   nonvar(B), B = y(_), !, 
   cleanup(Rest,NRest).

cleanup([get(Ann,A,B)|Rest],
	[put(value,B,x(8)),get(Ann,A,x(8))|NRest]) :-
   nonvar(B), B = y(_), !, 
   cleanup(Rest,NRest).

cleanup([I|Rest],[I|NRest]) :- cleanup(Rest,NRest).

cleanup([],[]).

% Pass 3.

temp_value([I|Rest], [NI|NRest]) :-
	I=..[N,unsafe_value,X|RI],
	nonvar(X), X=x(_), !,
	NI=..[N,value,X|RI],
	temp_value(Rest, NRest).
temp_value([I|Rest], [I|NRest]) :-
	temp_value(Rest, NRest).
temp_value([], []).
