
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

% Convert unraveled code into partial object code:

partobj([Head|BodyGoals], [HeadObj|BodyObj], Perms) :-
	Head=..[_|Args],
	getputblock(get, Args, HeadObj, 1),
	xpartobj(BodyGoals, Perms, BodyObj, yes), !.


xpartobj([], _, [], _).
xpartobj([Dis|Rest], Perms, Result, Flag) :-
	Dis=(_;_), !,
	% Initialize permanent variables just before first disjunction:
	initperms(Flag, Perms, Result, [DisCode|RestCode]),
	dispartobj(Dis, Perms, DisCode),
	xpartobj(Rest, Perms, RestCode, no).
xpartobj([Goal|Rest], Perms, [GoalCode|RestCode], Flag) :-
	goalpartobj(Goal, Perms, GoalCode),
	xpartobj(Rest, Perms, RestCode, Flag).

	initperms(yes, Perms, [PermInit|R], R) :- !,
		initblock(Perms, PermInit).
	initperms(_, _, R, R).

dispartobj((A;B), Perms, (ACode;BCode)) :-
	xpartobj(A, Perms, ACode, no),
	dispartobj(B, Perms, BCode).
dispartobj(A, Perms, ACode) :-
	xpartobj(A, Perms, ACode, no). 


% Convert goals into their object code:
% Recognizes !, true, unify goals, and calls with simple arguments:

% Convert '!' into cut instruction:
goalpartobj(!, _, [cut|Link]-Link).
% Cut in a disjunction is handled for objcode:
goalpartobj('->', _, cutd). % Note: not a list, so objcode is signaled.
% 'true' needs no code:
goalpartobj(true, _, Link-Link).
% translation of unify goals:
goalpartobj(V=W, Perms, [put(_,V,Temp)|Code]-Link) :-
	unify_temp(V, Perms, Temp),
	unify_2ndpart(W, Temp, Code-Link).
% Added clause for VLSI PLM:
% goalpartobj(is(Out,A,Op,B), _, Code-Link) :-
% 	compile_options(s),
% 	vlsi_instr(Op, Opcode), !,
% 	Instr=..[Opcode,x(N),x(M)],
% 	Code=[put(T1,A,x(N)),
% 	      put(T2,B,x(M)),
% 	      deref(x(N)),
% 	      deref(x(M)),
% 	      Instr,
% 	      put(constant, xF3FFFFFF, x(1)),
% 	      and(x(1),x(M)),
% 	      get(T3,Out,x(M))|Link],
% 	simple_type(A,T1),
% 	simple_type(B,T2),
% 	simple_type(Out,T3).
% translation of other goals:
goalpartobj(Goal, _, Code-Link) :-
	Goal=..[Name|Args],
	my_length(Args, Arity),
	getputblock(put, Args, Code-L, 1),
	goal_call(Name, Arity, L, Link).

	% Get the temporary variable for unify goals:
	unify_temp(V, Perms, x(8)) :- in(V, Perms), !.
	unify_temp(V, Perms, V).

	% Create the call:
	goal_call(Name, Arity, [Name/Arity|L], L) :-
		escape_builtin(Name,Arity), !.
	goal_call(Name, Arity, [call(Name,_)|L], L).

	% Get type annotation of simple argument:
	simple_type(A, constant) :- atomic(A), !.
	simple_type(V, _) :- var(V), !.

% Code for second argument of '=' predicate:
unify_2ndpart(W, Temp, [get(_,W,Temp)|Link]-Link) :-
	var(W), !.
unify_2ndpart(W, Temp, [get(constant,W,Temp)|Link]-Link) :-
	atomic(W), !.
unify_2ndpart(W, Temp, [get(structure,'.'/2,Temp)|L]-Link) :-
	list(W), !,
	unifyblock(list, W, L-Link).
unify_2ndpart(W, Temp, [get(structure,Name/Arity,Temp)|L]-Link) :- !,
	W=..[Name|Args], my_length(Args, Arity),
	unifyblock(nonlist, Args, L-Link).

% Initialization of variables:
% Uses register 8 as a holder.
initblock([], Link-Link).
initblock([V|Vars], [put(_,V,x(8))|Rest]-Link) :-
	initblock(Vars, Rest-Link).

% Get or put of all head arguments:
% (If Type is get or put).
getputblock(Type, [A|Args], [X|Rest]-Link, N) :-
	X=..[Type,T,A,x(N)],
	(atomic(A) -> T=constant; true),
	N1 is N+1,
	getputblock(Type, Args, Rest-Link, N1).
getputblock(_, [], Link-Link, _).

% Block of unify instructions to unify structures or lists:
unifyblock(nonlist, [], [unify_nil|Link]-Link).
unifyblock(list, V, [unify(cdr,x(8)),get(_,V,x(8))|Link]-Link) :- var(V), !.
unifyblock(list, [], [unify_nil|Link]-Link) :- !.
unifyblock(Type, [A|Args], [unify(T,A)|Rest]-Link) :-
	(atomic(A) -> T=constant; true),
	unifyblock(Type, Args, Rest-Link).
