
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

% Take care of void variables:
% 	(1) Remove gets
%	(2) Instantiate unallocated variables
%	(3) Collect unifys

% Bug fix Jan. 15, 1987: old version left some unallocated
% voids uninstantiated.  Two fixes were considered:
% source code transformation & simple use of x(8).
% For simplicity the latter was done here.

% Remove superfluous gets of voids:
voidalloc([get(_,A,_)|Code], VCode) :-
	var(A), !,
	voidalloc(Code, VCode).

% Collect unifies of voids and replace by unify_void N:
voidalloc(Code, [unify(void,N)|VCode]) :-
	collect_voids(Code, Rest, N), N>0, !,
	voidalloc(Rest, VCode).

% Instantiate puts of voids to registers:
voidalloc([X|Code], [X|VCode]) :-
	inst_void(X), !,
	voidalloc(Code, VCode).

% Default clause:
voidalloc([I|Code], [I|VCode]) :- !,
	voidalloc(Code, VCode).
voidalloc([], []).

	
	collect_voids([unify(_,Arg)|Code], Rest, N) :-
		var(Arg), !,
		collect_voids(Code, Rest, N1),
		N is N1+1 .
	collect_voids(Code, Rest, 0) :- Rest=Code.

% Bug fix Jan. 15: added this predicate.
% Instantiate variables left unallocated to x(8):

inst_void(unify(cdr,x(8))) :- !.
inst_void(put(variable,x(8),x(8))) :- !.
inst_void(put(variable,R,R)) :- !.
inst_void(get(structure,_,x(8))) :- !.
inst_void(put(structure,_,x(8))) :- !.
