
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>

extern caddr_t brk();
extern caddr_t sbrk();
extern getrlimit();
extern setrlimit();

int test_limit(limit)
int limit;
{
   static caddr_t bottom;

   if (bottom == NULL)		/* first call to test_limit */
     bottom = sbrk(0);
  return (brk(bottom + limit) == (caddr_t)(-1)) ? 0 : 1;
}

int binary_search(lower, upper, precision, predicate)
int lower, upper, precision, (*predicate)();
{
   int c;

   for(;;) {
      if ((upper - lower) < precision)
	return lower;
      c = (lower + upper) / 2;
      if ((*predicate)(c)) 
	lower = c;
      else
	upper = c;
   }
}
     
main()
{
   int lower_limit, upper_limit, precision, exact_limit;
   struct rlimit rl;

   if (getrlimit(RLIMIT_DATA, &rl)) return -1;
   rl.rlim_cur = rl.rlim_max;
   if (setrlimit(RLIMIT_DATA, &rl)) return -1;
   printf("%d kbytes system limit\n", rl.rlim_cur / 1000);

   lower_limit = getpagesize();
   precision = lower_limit / 2;
   upper_limit = rl.rlim_cur;
   exact_limit = binary_search(lower_limit,
			       upper_limit,
			       precision,
			       test_limit);
   printf("%d kbytes available\n", exact_limit / 1000);
}

