/* $Header: att_par.c,v 3.0 88/04/13 15:41:37 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */

#include "types.h"
#include "att_par.h"

struct attdef_struct {
	String  name;
	int     decl_val;
	String *range;
	int     def_type;
	String  def_val;
	String  cur_val;
};

#include "att_par.i"

String att_name(attdef)
P_Attdef attdef;
{
	if (attdef) return(attdef->name);
	return(0);
}

int att_declared_value(attdef)
P_Attdef attdef;
{
	if (attdef) return(attdef->decl_val);
	return(0);
}

String *att_range(attdef)
P_Attdef attdef;
{
	if (attdef) return(attdef->range);
	return(0);
}

int att_default_type(attdef)
P_Attdef attdef;
{
	if (attdef) return(attdef->def_type);
	return(0);
}

String att_default_value(attdef)
P_Attdef attdef;
{
	if (attdef) return(attdef->def_val);
	return(0);
}

String att_current_value(attdef)
P_Attdef attdef;
{
	if (attdef) return(attdef->cur_val);
	return(0);
}

void att_set_default_value(attdef, def_value)
P_Attdef attdef;
String   def_value;
{
	if (attdef->def_type != CURRENT) return;
	if (attdef->def_val != 0)  CFREE(attdef->def_val);
	attdef->def_val = def_value;
}

void att_set_current_value(attdef, cur_val)
P_Attdef attdef;
String   cur_val;
{
	if (attdef->cur_val != 0) CFREE(attdef->cur_val);
	attdef->cur_val = cur_val;
}

P_Att_iter attdef_iterator(attlist)
P_Attdeflist attlist;
{
	return(attlist);
}

P_Attdef att_iter_next(iter)
P_Att_iter *iter;
{
	P_Attdef attdef = *iter;

	if( (attdef != 0) and (att_name(attdef) != 0) ){
	    (*iter)++;
	    return(attdef);
	} else {
	    return 0;
	}
}

P_Attdef attdef_name_lookup(attlist, att_name)
P_Attdeflist attlist;
String       att_name;
{
	P_Attdef   attdef;
	P_Att_iter iter;

	if( NAMECASE_GENERAL ){ to_upper(att_name); }
	iter = attdef_iterator(attlist);
	while ((attdef = att_next(iter)) and
	       (strcmp(attdef->name, att_name) != 0)) ;
	return(attdef);
}

P_Attdef attdef_value_lookup(attlist, att_value)
P_Attdeflist attlist;
String       att_value;
{
	P_Attdef   attdef;
	P_Attdef   att_val = 0;
	P_Att_iter iter;
	int        i;

	if( NAMECASE_GENERAL ){ to_upper(att_value); }
	iter = attdef_iterator(attlist);
	while (attdef = att_next(iter))
	    if ((attdef->decl_val == NOTATION) or
		(attdef->decl_val == ENUMERATE)) {
		i = 0;
		while (attdef->range != 0 and attdef->range[i] != 0) {
		    if (strcmp(attdef->range[i], att_value) == 0)
		        if (att_val != 0) {
			    report(ATTR_DOUBLE, FATAL, 0, 0, att_value);
			    return(0);
		        }
		        else att_val = attdef;
		    i++;
	        }
	    }
	if (att_val == 0) report(ATTR_NO_NAME, FATAL, 0, 0, att_value);
	return(att_val);
}
