{
#include "types.h"
#include "lexical.h"
#include "modes.h"
#include "startend.h"

static Bool error = FALSE;
static char string[DATALEN + 1];
}
%onerror myerror;

%token ST_INETDOC1, END_INETDOC1;
%token ST_INDRAFT, END_INDRAFT;
%token ST_RFC, END_RFC;
%token ST_ABSTRACT, END_ABSTRACT;
%token ST_ACKS, END_ACKS;
%token ST_AUTHADDR, END_AUTHADDR;
%token ST_AUTHLIST, END_AUTHLIST;
%token ST_BODY, END_BODY;
%token ST_DATE, END_DATE;
%token ST_DIST, END_DIST;
%token ST_REFS, END_REFS;
%token ST_RELATION, END_RELATION;
%token ST_SAUTHOR, END_SAUTHOR;
%token ST_SECURITY, END_SECURITY;
%token ST_STATUS, END_STATUS;
%token ST_STITLE, END_STITLE;
%token ST_TITLE, END_TITLE;
%token ST_WKGROUP, END_WKGROUP;
%token ST_P, END_P;
%token ST_QP, END_QP;
%token ST_TP, END_TP;
%token ST_LIST, END_LIST;
%token ST_ITEM, END_ITEM;
%token ST_H0, END_H0;
%token ST_H1, END_H1;
%token ST_H2, END_H2;
%token ST_H3, END_H3;
%token ST_H4, END_H4;
%token ST_H5, END_H5;
%token ST_H6, END_H6;
%token ST_H7, END_H7;
%token ST_H8, END_H8;
%token ST_H9, END_H9;
%token ST_ADDRESS, END_ADDRESS;
%token ST_CITY, END_CITY;
%token ST_COUNTRY, END_COUNTRY;
%token ST_CSUB, END_CSUB;
%token ST_EMAIL, END_EMAIL;
%token ST_FAX, END_FAX;
%token ST_NAME, END_NAME;
%token ST_ORG, END_ORG;
%token ST_PCODE, END_PCODE;
%token ST_PHONE, END_PHONE;
%token ST_STREET, END_STREET;
%token ST_B, END_B;
%token ST_C, END_C;
%token ST_I, END_I;
%token ST_R, END_R;
%token ST_Q, END_Q;
%token ST_EMQ, END_EMQ;
%token ST_CITE, END_CITE;
%token ST_AREF, END_AREF;
%token ST_BREF, END_BREF;
%token ST_RAUTHORS, END_RAUTHORS;
%token ST_BTITLE, END_BTITLE;
%token ST_PUBCITY, END_PUBCITY;
%token ST_PUBNAME, END_PUBNAME;
%token ST_PUBDATE, END_PUBDATE;
%token ST_ATITLE, END_ATITLE;
%token ST_PTITLE, END_PTITLE;
%token ST_VOL, END_VOL;
%token ST_PDATE, END_PDATE;
%token ST_PAGES, END_PAGES;
%token ST_FIG, END_FIG;
%token ST_FTITLE, END_FTITLE;
%token ST_FDATA, END_FDATA;
%token ST_TBL, END_TBL;
%token ST_TTITLE, END_TTITLE;
%token ST_THEAD, END_THEAD;
%token ST_ROW, END_ROW;
%token ST_COL, END_COL;
%token ST_DLINE, END_DLINE;
%token ST_SLINE, END_SLINE;
%token ST_DEQ, END_DEQ;
%token ST_EQ, END_EQ;
%token ST_AUTHINST, END_AUTHINST;
%token ST_AUTHNAME, END_AUTHNAME;
%token ST_OBS, END_OBS;
%token ST_UPD, END_UPD;
document :
	sep2 [[[ST_INETDOC1 ] INETDOC1 ]] sep2
	{ pars_document(); }
	;
INETDOC1 :
	{ pars_start(ST_INETDOC1); }
	sep2 [[[ST_RFC ] RFC ]|
	[[ST_INDRAFT ] INDRAFT ]] sep2
	END_INETDOC1
	{ pars_end(END_INETDOC1); }
	;
INDRAFT :
	{ pars_start(ST_INDRAFT); }
	sep2 [[[ST_WKGROUP ] WKGROUP ]sep2 
	[[ST_AUTHLIST ] AUTHLIST ]sep2 
	[[ST_SAUTHOR ] SAUTHOR ]sep2 
	[[ST_DATE ] DATE ]sep2 
	[[ST_RELATION ] RELATION ]?sep2 
	[[ST_TITLE ] TITLE ]sep2 
	[[ST_STITLE ] STITLE ]sep2 
	[[ST_STATUS ] STATUS ]sep2 
	[[ST_DIST ] DIST ]sep2 
	[[ST_ABSTRACT ] ABSTRACT ]sep2 
	[[ST_BODY ] BODY ]sep2 
	[[ST_ACKS ] ACKS ]?sep2 
	[[ST_REFS ] REFS ]?sep2 
	[[ST_SECURITY ] SECURITY ]sep2 
	[[ST_AUTHADDR ] AUTHADDR ]] sep2
	END_INDRAFT
	{ pars_end(END_INDRAFT); }
	;
RFC :
	{ pars_start(ST_RFC); }
	sep2 [[[ST_WKGROUP ] WKGROUP ]sep2 
	[[ST_AUTHLIST ] AUTHLIST ]sep2 
	[[ST_SAUTHOR ] SAUTHOR ]sep2 
	[[ST_DATE ] DATE ]sep2 
	[[ST_RELATION ] RELATION ]?sep2 
	[[ST_TITLE ] TITLE ]sep2 
	[[ST_STITLE ] STITLE ]sep2 
	[[ST_STATUS ] STATUS ]sep2 
	[[ST_DIST ] DIST ]sep2 
	[[ST_ABSTRACT ] ABSTRACT ]sep2 
	[[ST_BODY ] BODY ]sep2 
	[[ST_ACKS ] ACKS ]?sep2 
	[[ST_REFS ] REFS ]?sep2 
	[[ST_SECURITY ] SECURITY ]sep2 
	[[ST_AUTHADDR ] AUTHADDR ]] sep2
	END_RFC
	{ pars_end(END_RFC); }
	;
ABSTRACT :
	{ pars_start(ST_ABSTRACT); }
	sep2 [[[[ST_P ] P ]|
	[[ST_QP ] QP ]|
	[[ST_TP ] TP ]|
	[[ST_LIST ] LIST ]]sep2 
	[%while(1) [[[ST_P ] P ]|
	[[ST_QP ] QP ]|
	[[ST_TP ] TP ]|
	[[ST_LIST ] LIST ] ] sep2 ]*] sep2
	END_ABSTRACT
	{ pars_end(END_ABSTRACT); }
	;
ACKS :
	{ pars_start(ST_ACKS); }
	sep2 [[[[ST_P ] P ]|
	[[ST_QP ] QP ]|
	[[ST_TP ] TP ]|
	[[ST_LIST ] LIST ]]sep2 
	[%while(1) [[[ST_P ] P ]|
	[[ST_QP ] QP ]|
	[[ST_TP ] TP ]|
	[[ST_LIST ] LIST ] ] sep2 ]*] sep2
	END_ACKS
	{ pars_end(END_ACKS); }
	;
AUTHADDR :
	{ pars_start(ST_AUTHADDR); }
	sep2 [[[ST_ADDRESS ] ADDRESS ]sep2 
	[%while(1) [[ST_ADDRESS ] ADDRESS  ] sep2 ]*] sep2
	END_AUTHADDR
	{ pars_end(END_AUTHADDR); }
	;
AUTHLIST :
	{ pars_start(ST_AUTHLIST); }
	sep2 [[[[ST_AUTHNAME ] AUTHNAME ]sep2 
	[[ST_AUTHINST ] AUTHINST ]]sep2 
	[%while(1) [[[ST_AUTHNAME ] AUTHNAME ]sep2 
	[[ST_AUTHINST ] AUTHINST ] ] sep2 ]*] sep2
	END_AUTHLIST
	{ pars_end(END_AUTHLIST); }
	;
BODY :
	{ pars_start(ST_BODY); }
	sep2 [[[[ST_H0 ] H0 ]|
	[[ST_H1 ] H1 ]|
	[[ST_H2 ] H2 ]|
	[[ST_H3 ] H3 ]|
	[[ST_H4 ] H4 ]|
	[[ST_H5 ] H5 ]|
	[[ST_H6 ] H6 ]|
	[[ST_H7 ] H7 ]|
	[[ST_H8 ] H8 ]|
	[[ST_H9 ] H9 ]|
	[[ST_P ] P ]|
	[[ST_QP ] QP ]|
	[[ST_TP ] TP ]|
	[[ST_LIST ] LIST ]|
	[[ST_DEQ ] DEQ ]|
	[[ST_FIG ] FIG ]|
	[[ST_TBL ] TBL ]]sep2 
	[%while(1) [[[ST_H0 ] H0 ]|
	[[ST_H1 ] H1 ]|
	[[ST_H2 ] H2 ]|
	[[ST_H3 ] H3 ]|
	[[ST_H4 ] H4 ]|
	[[ST_H5 ] H5 ]|
	[[ST_H6 ] H6 ]|
	[[ST_H7 ] H7 ]|
	[[ST_H8 ] H8 ]|
	[[ST_H9 ] H9 ]|
	[[ST_P ] P ]|
	[[ST_QP ] QP ]|
	[[ST_TP ] TP ]|
	[[ST_LIST ] LIST ]|
	[[ST_DEQ ] DEQ ]|
	[[ST_FIG ] FIG ]|
	[[ST_TBL ] TBL ] ] sep2 ]*] sep2
	END_BODY
	{ pars_end(END_BODY); }
	;
DATE :
	{ pars_start(ST_DATE); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_DATE
	{ pars_end(END_DATE); }
	;
DIST :
	{ pars_start(ST_DIST); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_DIST
	{ pars_end(END_DIST); }
	;
REFS :
	{ pars_start(ST_REFS); }
	sep2 [[[[ST_AREF ] AREF ]|
	[[ST_BREF ] BREF ]]sep2 
	[%while(1) [[[ST_AREF ] AREF ]|
	[[ST_BREF ] BREF ] ] sep2 ]*] sep2
	END_REFS
	{ pars_end(END_REFS); }
	;
RELATION :
	{ pars_start(ST_RELATION); }
	sep2 [[[ST_OBS ] OBS ]|
	[[ST_UPD ] UPD ]] sep2
	END_RELATION
	{ pars_end(END_RELATION); }
	;
SAUTHOR :
	{ pars_start(ST_SAUTHOR); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_SAUTHOR
	{ pars_end(END_SAUTHOR); }
	;
SECURITY :
	{ pars_start(ST_SECURITY); }
	sep2 [[[[ST_P ] P ]|
	[[ST_QP ] QP ]|
	[[ST_TP ] TP ]|
	[[ST_LIST ] LIST ]]sep2 
	[%while(1) [[[ST_P ] P ]|
	[[ST_QP ] QP ]|
	[[ST_TP ] TP ]|
	[[ST_LIST ] LIST ] ] sep2 ]*] sep2
	END_SECURITY
	{ pars_end(END_SECURITY); }
	;
STATUS :
	{ pars_start(ST_STATUS); }
	sep2 [[[[ST_P ] P ]|
	[[ST_QP ] QP ]|
	[[ST_TP ] TP ]|
	[[ST_LIST ] LIST ]]sep2 
	[%while(1) [[[ST_P ] P ]|
	[[ST_QP ] QP ]|
	[[ST_TP ] TP ]|
	[[ST_LIST ] LIST ] ] sep2 ]*] sep2
	END_STATUS
	{ pars_end(END_STATUS); }
	;
STITLE :
	{ pars_start(ST_STITLE); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_STITLE
	{ pars_end(END_STITLE); }
	;
TITLE :
	{ pars_start(ST_TITLE); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_TITLE
	{ pars_end(END_TITLE); }
	;
WKGROUP :
	{ pars_start(ST_WKGROUP); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_WKGROUP
	{ pars_end(END_WKGROUP); }
	;
P :
	{ pars_start(ST_P); }
	sep1 [%while(1) [%prefer [xpcdata(string, DATALEN, TRUE, &error)]|
	[[ST_CITE ] CITE ]|
	[[ST_EQ ] EQ ]|
	[[ST_B ] B ]|
	[[ST_C ] C ]|
	[[ST_I ] I ]|
	[[ST_R ] R ]|
	[[ST_EMQ ] EMQ ]|
	[[ST_Q ] Q ] ] sep1 ]* sep1
	END_P
	{ pars_end(END_P); }
	;
