{
#include "types.h"
#include "lexical.h"
#include "modes.h"
#include "startend.h"

static Bool error = FALSE;
static char string[DATALEN + 1];
}
NAME :
	{ pars_start(ST_NAME); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_NAME
	{ pars_end(END_NAME); }
	;
ORG :
	{ pars_start(ST_ORG); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_ORG
	{ pars_end(END_ORG); }
	;
PCODE :
	{ pars_start(ST_PCODE); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_PCODE
	{ pars_end(END_PCODE); }
	;
PHONE :
	{ pars_start(ST_PHONE); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_PHONE
	{ pars_end(END_PHONE); }
	;
STREET :
	{ pars_start(ST_STREET); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_STREET
	{ pars_end(END_STREET); }
	;
B :
	{ pars_start(ST_B); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_B
	{ pars_end(END_B); }
	;
C :
	{ pars_start(ST_C); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_C
	{ pars_end(END_C); }
	;
I :
	{ pars_start(ST_I); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_I
	{ pars_end(END_I); }
	;
R :
	{ pars_start(ST_R); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_R
	{ pars_end(END_R); }
	;
Q :
	{ pars_start(ST_Q); }
	sep1 [%while(1) [%prefer [xpcdata(string, DATALEN, TRUE, &error)]|
	[[ST_EMQ ] EMQ ]|
	[[ST_B ] B ]|
	[[ST_C ] C ]|
	[[ST_I ] I ]|
	[[ST_R ] R ] ] sep1 ]* sep1
	END_Q
	{ pars_end(END_Q); }
	;
EMQ :
	{ pars_start(ST_EMQ); }
	sep1 [%while(1) [%prefer [xpcdata(string, DATALEN, TRUE, &error)]|
	[[ST_B ] B ]|
	[[ST_C ] C ]|
	[[ST_I ] I ]|
	[[ST_R ] R ] ] sep1 ]* sep1
	END_EMQ
	{ pars_end(END_EMQ); }
	;
CITE :
	{ pars_start(ST_CITE); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_CITE
	{ pars_end(END_CITE); }
	;
AREF :
	{ pars_start(ST_AREF); }
	sep2 [[[ST_CITE ] CITE ]sep2 
	[[ST_RAUTHORS ] RAUTHORS ]sep2 
	[[ST_ATITLE ] ATITLE ]sep2 
	[[ST_PTITLE ] PTITLE ]sep2 
	[[ST_VOL ] VOL ]sep2 
	[[ST_PDATE ] PDATE ]sep2 
	[[ST_PAGES ] PAGES ]] sep2
	END_AREF
	{ pars_end(END_AREF); }
	;
BREF :
	{ pars_start(ST_BREF); }
	sep2 [[[ST_CITE ] CITE ]sep2 
	[[ST_RAUTHORS ] RAUTHORS ]sep2 
	[[ST_BTITLE ] BTITLE ]sep2 
	[[ST_PUBCITY ] PUBCITY ]sep2 
	[[ST_PUBNAME ] PUBNAME ]sep2 
	[[ST_PUBDATE ] PUBDATE ]] sep2
	END_BREF
	{ pars_end(END_BREF); }
	;
RAUTHORS :
	{ pars_start(ST_RAUTHORS); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_RAUTHORS
	{ pars_end(END_RAUTHORS); }
	;
BTITLE :
	{ pars_start(ST_BTITLE); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_BTITLE
	{ pars_end(END_BTITLE); }
	;
PUBCITY :
	{ pars_start(ST_PUBCITY); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_PUBCITY
	{ pars_end(END_PUBCITY); }
	;
PUBNAME :
	{ pars_start(ST_PUBNAME); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_PUBNAME
	{ pars_end(END_PUBNAME); }
	;
PUBDATE :
	{ pars_start(ST_PUBDATE); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_PUBDATE
	{ pars_end(END_PUBDATE); }
	;
ATITLE :
	{ pars_start(ST_ATITLE); }
	sep1 [pcdata(string, DATALEN, TRUE, &error)] sep1
	END_ATITLE
	{ pars_end(END_ATITLE); }
	;
