/*  $Header: elem.g,v 3.0 88/04/13 16:38:51 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
{
#include "types.h"
#include "element.h"
#include "lexical.h"
#include "modes.h"
#include "node.h"
}

elem_decl
{
    P_Node     n;
    P_Group    elem_group;
    P_Group    incl_group;
    P_Group    excl_group;
    int        start_minim;
    int        end_minim;
    int        key;
    String     str;
} :
	[ MDO_ELEMENT                                   { enter_mode(MODE_MD); }
	      {
		  elem_group = group_create();
		  incl_group = (P_Group) 0;
		  excl_group = (P_Group) 0;
	      }
	  ps_plus elem_type(elem_group) ps_plus
	  [ omit_tag_minim(&start_minim, &end_minim) ps_plus ]
	  [   [ keyword(&key, &str)
                {
		    if( not check_int(key, ANY, CDATA, RCDATA, EMPTY, 0) ){
			report(KEY_WRONG, FATAL, 0, 0, str, "declared content",
			       "CDATA,RCDATA,EMPTY, ANY", "CDATA");
			key = CDATA;
		    }
		    n = new_node_key(key);
		}
	        [exceptions(&excl_group, &incl_group)]
	      ]
	    | [ content_model(&n, &excl_group, &incl_group)
              ]
	  ]
	      { 
		define_element(elem_group, start_minim, end_minim, n,
			       excl_group, incl_group);
	      }
	  TOK_MDC                                      { leave_mode(); }
	] ;

elem_type(P_Group g;)
{
    char  string[NAMELEN + 1];
} :
	[ name(string, NAMECASE_GENERAL)                /* was : gen_ident() */
	      { group_add(g, strsave(string)); }
	| name_group(g, NAMECASE_GENERAL)
	]
	    { String tmp;
	      P_Iterator it = group_iterator(g);

	      while( tmp = next_name(it) ){
                  to_upper(tmp);
	      }
	    }
	;

omit_tag_minim( int *start; int *end; ) :
	[
	    tag_minim(start) ps_plus tag_minim(end)
	] ;

tag_minim( int *value;) :
	[  [ TOK_LETTER
	        { *value = TRUE;  } ]
	 | [ TOK_MINUS
	        { *value = FALSE;  } ]
        ] ;

content_model(P_Node *n; P_Group *excl; P_Group *incl;) :
	[
	  model_group(n)
	  exceptions(excl, incl)
	] ;

exceptions(P_Group *excl; P_Group *incl;) :
	[ ps_star] [exclusions(excl) ps_star]? [inclusions(incl) ps_star]?
	;

model_group(P_Node *n;)
{
    P_Node  node;
    int     occ;
    int     conn, first_con=TOK_NOD;
} :
	[ TOK_GRPO                             { enter_mode(MODE_GRP); }
	      { *n = new_node_group(); }
	  ts_star content_token(&node) ts_star
	  [ connector(&conn) ts_star
	      { node_add(*n, node); }
	    content_token(&node) ts_star
		{
		  if( first_con == TOK_NOD ){             /* first connector */
		      first_con = conn;
		      node_set_group_type(*n, conn);
		  } else if( conn != first_con ){
		      report(DIFF_CONN, FATAL, 0, 0);
		  }
		}
	  ]*
	      { if( node_type(*n) == GROUP ){
		    delete_node(*n);
		    *n = node;
		} else {
		    node_add(*n, node);
		}
	      }
	  TOK_GRPC                                     { leave_mode(); }
          [%while(1)  occurr_indicator(&occ)
		{  if( (*n) == node ){
		       occ = combine_occ(occ, node_occ(*n));
		       if( node_type(*n) == KEY ){    /* for PCDATA */
			   occ = NO_OCC;
		       }
		   }
		   node_set_occ(*n, occ);
		}
	  ]?
	] ;

content_token(P_Node *n;) :
	[   prim_content_token(n)
	  | model_group(n)
	] ;

prim_content_token(P_Node *n;)
{
    int      key;
    String   str;
} :
	[   [ TOK_RNI keyword(&key, &str) 			/* PCDATA */
	      {
		  if( not check_int(key, PCDATA, 0) ){
		      report(KEY_WRONG, FATAL, 0, 0, str, "content model",
					      "PCDATA", "PCDATA");
		      key = PCDATA;
		  }
	  	  *n = new_node_key(key);
	      }
	    ]
	  | elem_token(n)
	] ;

elem_token(P_Node *n;)
{
    int  occ;
    char gi[NAMELEN + 1];
} :
	[ name(gi, NAMECASE_GENERAL)                   /* was : gen_ident() */
	      { *n = new_node_gi(strsave(gi)); }
	  [ occurr_indicator(&occ)
		{ node_set_occ(*n, occ); }
	  ]?
	] ;

occurr_indicator(int *occ;) :
	[ TOK_OPT  { *occ = OCC_OPT ; }
	| TOK_PLUS { *occ = OCC_PLUS; }
	| TOK_REP  { *occ = OCC_REP ; }
	]
        ;

inclusions(P_Group *g;) : [ { *g = group_create(); } 
			    TOK_PLUS name_group(*g, NAMECASE_GENERAL)
			 ] ;

exclusions(P_Group *g;) : [ { *g = group_create(); }
			    TOK_MINUS name_group(*g, NAMECASE_GENERAL)
			 ] ;
