/*  $Header: extern.g,v 3.0 88/04/14 08:36:24 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
{
#include "types.h"
#include "entity.h"
#include "lexical.h"
#include "modes.h"

#ifdef DEBUG
static Bool debug = FALSE;

void debug_extern(b)
Bool b;
{
	debug = b;
}
#endif
}

extern_ident_short(P_Extern_id *ex_id; int type;)
{
    char  public_str[LITLEN + 1];
    char  system_str[LITLEN + 1];
} :
       [
		{ public_str[0] = '\0'; }
		{ system_str[0] = '\0'; }
	 [%while( type == PUBLIC )
		            /* else assert(ex_id->ex_type==SYSTEM"); */
	    min_literal(public_str)     /* was : public_ident */
		{
		  DEB1("extern_id pub : `%s'\n", public_str); 
		}
	    ps_star
	  ]?
	  [ system_ident(system_str) ps_star]?
	    {
		DEB1("extern_id sys : `%s'\n", system_str);
		*ex_id = new_extern_id(type, strsave(public_str),
					       strsave(system_str));
	    }
	] ;

system_ident(String str;) { Bool error = FALSE; }:
        [ TOK_LIT		{ enter_mode(MODE_LIT_ERO); }
	  cdata(str, LITLEN, FALSE, &error)
					  /* was : system_data(str) */
	        { if (error)
		     report(WAR_LITLEN, NOTFATAL, 0, 0,
			    "system ident. length", LITLEN);
	        }
	  TOK_LIT		{ leave_mode(); }
        ]
      | [ TOK_LITA		{ enter_mode(MODE_LITA_ERO); }
	  cdata(str, LITLEN, FALSE, &error)
						   /* was : system_data(str) */
	        { if (error)
		     report(WAR_LITLEN, NOTFATAL, 0, 0,
			    "system ident. length", LITLEN);
	        }
	  TOK_LITA		{ leave_mode(); }
        ] ;

min_literal(String str;) :
	[ TOK_LIT                          { enter_mode(MODE_LIT_ERO); }
	  min_data(str)
	  TOK_LIT                              { leave_mode(); }
        ]
      | [ TOK_LITA                         { enter_mode(MODE_LITA_ERO);}
	  min_data(str)
	  TOK_LITA                             { leave_mode(); }
        ] ;

min_data(String str;)
{
    int  i = 0;
    char ch;
    Bool error = FALSE;
} :
	[ min_data_char(&ch)
	    { if (i >= LITLEN and !error) {
		 report(WAR_LITLEN, NOTFATAL, 0, 0,
			"minimum literal length", LITLEN);
		 error = TRUE;
	      }
	      else if (!error) { str[i] = ch; i++; } 
	    }
        ]*
	    { str[i] = '\0'; }
        ;

min_data_char(char *ch;) :
	[ TOK_RS | TOK_RE | TOK_SPACE |
	  TOK_LETTER | TOK_DIGIT | TOK_SPECIAL
	]
			   { *ch = current_value(); }
	;
