/*  $Header: file_in.c,v 3.3 88/07/19 09:55:47 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "file_in.h"

#define BUFFER_LENGTH 1300
#define INC(i)        i = ((i) + 1) mod BUFFER_LENGTH
#define DEC(i)        i = ((i) - 1 + BUFFER_LENGTH) mod BUFFER_LENGTH
#define PLUS(i,p)     ((i+p) mod BUFFER_LENGTH)

typedef struct Filestream_struct {
    FILE    *file;
    int      buffer[BUFFER_LENGTH];
    int      index;
    int      again;
    int      line_nr;
    String   name;
} Filestream;

/*
 *  functions for file input.
 */
static P_Filestream f;
static char         current_line[BUFFER_LENGTH];

P_Filestream  new_file_stream(file, name)
FILE   *file;
String  name;
{
    P_Filestream  fs;

    fs = (P_Filestream)MALLOC( (unsigned)( sizeof(Filestream) ) );
    fs->file    = file;
    fs->index   = -1;
    fs->again   = FALSE;
    fs->line_nr = 1;
    fs->name    = strsave(name);
    return fs;
}

void delete_file_stream(ff)
P_Filestream ff;
{
    FREE(ff->name, strlen(ff->name));
    FREE(ff, sizeof(Filestream));
}

void file_stream(ff)
P_Filestream ff;
{
    f = ff;
}

int file_current_ch()
{
    return f->buffer[f->index];
}

int file_next_ch()
{
    int ch;

    if( f->again ){
        f->again--;
	INC(f->index);
        ch = f->buffer[f->index];
    } else {
	INC(f->index);
        ch = getc(f->file);
        f->buffer[f->index] = ch;
    }
    if( ch == '\n' ){ f->line_nr++; }
    return ch;
}

void file_pushback_ch(l)
int l;
{
    int i;

    if( l >= BUFFER_LENGTH ){
	report(SYSTEM_PUSH, FATAL, 0, 0, BUFFER_LENGTH);
	l = BUFFER_LENGTH-1;
    }

    if( (f->index - l) >= 0 ){
	for(i=f->index; i>(f->index-l); i--){
	    if( f->buffer[i] == '\n' ){
		f->line_nr--;
	    }
	}
    } else {
	for(i=f->index; i>0 ; i--){
	    if( f->buffer[i] == '\n' ){
		f->line_nr--;
	    }
	}
	for(i=BUFFER_LENGTH-1; i>(f->index-l+BUFFER_LENGTH); i--){
	    if( f->buffer[i] == '\n' ){
		f->line_nr--;
	    }
	}
    }
    f->again += l;
    f->index = (f->index - l + BUFFER_LENGTH) mod BUFFER_LENGTH;
}

int file_line_nr()
{
    return f->line_nr;
}

String file_name()
{
    return f->name;
}

Bool in_range(PAR  int  RAP);

Bool in_range(k)
int k;
{
    Bool answer = (k < (BUFFER_LENGTH-1));

    if( not answer ){
	fprintf(stderr, "current line too big (>%d)\n", BUFFER_LENGTH);
    }
    return answer;
}

String file_current_line(current_char)
int*  current_char;
{
    long  fpos;
    char  ch  ;
    int   k   ;
    int   i    = (f->index - 1 + BUFFER_LENGTH) mod BUFFER_LENGTH;

    /*
     *  First see whether end of file is reached.
     */
    if( f->buffer[f->index] == EOF ){
	*current_char = 0;
	return ( (String) 0 );
    }
    /*
     *  find begin of current line 
     */
    if( (f->line_nr == 1) or			 /* cannot find previous '\n' */
	((f->line_nr == 2) and (f->buffer[f->index] == '\n')) )
    {
	i = 0;
    } else {
	while( f->buffer[i] != '\n' ){		/* find previous '\n' */
	    DEC(i);
	    if( i == PLUS(f->index, f->again) ){
		fprintf(stderr, "current line too big (>%d)\n", BUFFER_LENGTH);
		break;
	    }
	}
	INC(i);
    }
    *current_char = (f->index - i + 1 + BUFFER_LENGTH) mod BUFFER_LENGTH;
    
    k = 0;
    while( i != f->index ){			/* copy from begin to index */
	current_line[k++] = f->buffer[i];
	INC(i);
    }

    if( f->buffer[i] != '\n' ){
	if( in_range(k) ){
	    current_line[k++] = f->buffer[i];
	}

	i = 1;						 /* copy lookahead */
	while( (i <= f->again) and (f->buffer[PLUS(f->index, i)] != '\n') ){
	    if( not in_range(k) ){
		break;
	    }
	    current_line[k++] = f->buffer[PLUS(f->index, i)];
	    INC(i);
	}

	if( i>f->again ){			  /* read file to end of line */
	    fpos = ftell(f->file);
	    while( ( (ch=getc(f->file)) != '\n') and (ch != EOF) ){
		if( not in_range(k) ){
		    break;
		}
		current_line[k++] = ch;
	    }
	    fseek(f->file, fpos, 0);		/* reset file pointer */
	}
    }

    current_line[k] = '\0';
    return current_line;
}
