/* $Header: gen_tagl.c,v 3.0 88/04/13 15:33:27 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */

#include "types.h"
#include "element.h"
#include "gen_tagl.h"
#include "node.h"

static FILE *fp;
#define MAX_ELEM	10
static int   nr_elem = 0;

void elem_content(node, dummy)
P_Node     node;
P_Element  dummy;
{
	P_Iterator it, nmgroup;
	P_Element  elem;
	String     name;
	int        nr;

	switch (node_type(node)) {
	  case KEY:
		switch (node_key(node)) {
		  case EMPTY   : return;
		  case XPCDATA :
		  case PCDATA  :
			fprintf(fp, "PCDATA, ");
			break;
		  case CDATA   :
			fprintf(fp, "CDATA, ");
			return;
		  case RCDATA  :
			fprintf(fp, "RCDATA, ");
			return;
		  case ANY     :
			nr = 0;
			it = element_iterator();
			while (elem = next_element(it)) {
			    nmgroup = group_iterator(name_group(elem));
			    while (name = next_name(nmgroup)) {
				if (strcmp(name, DOCUMENT) != 0) {
				    fprintf(fp, "ST_%s, ", cname(name));
				    nr++;
				    if (nr > MAX_ELEM) {
					fprintf(fp, "\n");
					nr = 0;
				    }
				}
			    }
			}
			fprintf(fp, "PCDATA, ");
			return;
		  default :
			report(NO_LABEL, FATAL, 0, 0, node_type(node),
			       "elem_content");
			break;
		}
		break;
	  case GI :
		fprintf(fp, "ST_%s, ", cname(node_gi(node)));
		break;
	  default : return;
	}
	nr_elem++;
	if (nr_elem > MAX_ELEM) {
	    fprintf(fp, "\n");
	    nr_elem = 0;
	}
}

void taglist(elem)
P_Element elem;
{
	String     name;
	P_Iterator nmgroup;

	nmgroup = group_iterator(name_group(elem));
	while (name = next_name(nmgroup))
	  if (strcmp(name, DOCUMENT) != 0 ) {
	    fprintf(fp, "\tEND_%s, %s, {", cname(name), 
			omit_end(elem)?"TRUE":"FALSE");
	    node_traverse_post(content(elem), elem_content, elem);
	    fprintf(fp, "0}, \n");
	    nr_elem = 0;
	}
}

void generate_endlist(name)
String name;
{
	P_Iterator it;
	P_Element  elem;

	fp = fopen(name, "w");
	if (fp == 0) {
	    report(FILE_OPEN, FATAL, 0, 0, name);
	}
	fprintf(fp, "ttaglist taglist[] = {\n");

	it = element_iterator();
	while (elem = next_element(it)) taglist(elem);
	fprintf(fp, "\t0, FALSE, 0};\n");
	fclose(fp);
}
