/*  $Header: lexical.h,v 3.0 88/04/14 09:20:31 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
/*
 *  Tokens definition, link between lexical analyser and parser.
 */
#ifndef LEXICAL_H
#define LEXICAL_H

extern  Token           next_token();
extern  void            push_back_token();
extern  int             current_value  ();
extern  void            enter_mode     (PAR  RecognitionMode  RAP);
extern  void            leave_mode     ( );
extern  RecognitionMode current_mode   ();
extern  void            init_lexical   ( );
extern  void            param_name     (PAR  String  RAP);
extern  void            name_tail      (PAR  String  RAP);
extern  void            pero           (PAR  Bool  RAP);
extern  void            char_ref       ();

#ifdef DOC_PARSER
extern  int   handle_net_start(PAR  Token starttag, Token endtag RAP);
extern  int   handle_net_end  (PAR  Token endtag  RAP);
#endif

#ifdef DEBUG
extern  void            debug_lexical  (PAR  Bool  RAP);
#endif

#endif
