/* $Header: modes.h,v 3.0 88/04/14 09:20:38 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#ifndef MODES_H
#define MODES_H

/* enum RecognitionMode */
#define  ILL_MODE   		0
#define  MODE_COM   		1
#define  MODE_CON   		2
#define  MODE_CXT   		3
#define  MODE_DS    		4
#define  MODE_GRP   		5
#define  MODE_LIT_ERO  		6
#define  MODE_MD    		7
#define  MODE_PI    		8
#define  MODE_REF   		9
#define  MODE_TAG   		10
#define  MODE_IGNORE   		11
#define  MODE_RCDATA   		12
#define  MODE_LITA_ERO 		13
#define  MODE_SGML 		14
#define  MODE_CDATA 		15
#define  MODE_MARKED_CDATA 	16
#define  MODE_MARKED_RCDATA 	17
#define  MODE_LIT_PERO          18
#define  MODE_LITA_PERO         19

extern Delimiter*  delimiter_mode       (PAR  RecognitionMode  RAP);
extern Bool        mode_recognizes      (PAR  RecognitionMode, Delimiter RAP);
extern String      recognition_to_string(PAR  RecognitionMode  RAP);

#endif MODES_H
