/*  $Header: symtable.h,v 3.0 88/04/14 09:27:25 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
/*  Defines a type for a simple symbol-table.
 *  Each table must end with an entry {ILL_STRING, ILL_SYMBOL}
 */

#define  ILL_STRING  0
#define  ILL_SYMBOL  (-1)

typedef struct symtable_struct {   /* Describes a binding of a string  */
    String string;                 /* with an integer.                 */
    int    symbol;
} SymbolBinding;

typedef SymbolBinding SymbolTable[];

extern String symbol_string(PAR SymbolTable table, int    symbol  RAP);
extern int    string_symbol(PAR SymbolTable table, String string  RAP);
