/*  $Header: tags.h,v 3.0 88/04/14 09:29:27 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
/*  Find the tokens belonging to the start and end-tag keywords
 */

#ifndef __TAGS__
#define __TAGS__

extern int       document_start    ();
extern Delimiter starttag_keyword   (PAR  String name     RAP);
extern Delimiter endtag_keyword     (PAR  String name     RAP);
extern String    endtag_to_string   (PAR  int    tag      RAP);
extern String    starttag_to_string (PAR  int    tag      RAP);
extern P_Attdeflist  string_to_attrs(PAR  String name     RAP);

extern Parserinfo    string_info   (PAR  String element_name  RAP);
extern Parserinfo    starttag_info (PAR  int starttag     RAP);
extern Parserinfo    endtag_info   (PAR  int endtag     RAP);
extern String        info_name     (PAR  Parserinfo info  RAP);
extern int           info_starttag (PAR  Parserinfo info  RAP);
extern int           info_endtag   (PAR  Parserinfo info  RAP);
extern P_Attdeflist  info_attlist  (PAR  Parserinfo info  RAP);
extern int*          info_incl     (PAR  Parserinfo info  RAP);
extern int*          info_excl     (PAR  Parserinfo info  RAP);
extern P_Map         info_map      (PAR  Parserinfo info  RAP);
extern P_Replace     info_start_rep(PAR  Parserinfo info  RAP);
extern P_Replace     info_end_rep  (PAR  Parserinfo info  RAP);
extern void          info_set_start_rep(PAR  Parserinfo info, P_Replace  RAP);
extern void          info_set_end_rep  (PAR  Parserinfo info, P_Replace  RAP);

#ifndef ILL_STRING
#define ILL_STRING	0
#endif
#ifndef ILL_MAP
#define ILL_MAP   	0
#endif
#ifndef ILL_SYMBOL
#define ILL_SYMBOL	(-1)
#endif
#ifndef ILL_ATTR
#define ILL_ATTR	0
#endif
#ifndef ILL_EXCEP
#define ILL_EXCEP	0
#endif

#endif
