/* $Header: types.h,v 3.0 88/04/14 09:28:16 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#ifndef TYPES_H
#define TYPES_H

/* #define VMS */
#ifdef VMS
#define void   int

#define MALLOC malloc_u
#define CALLOC xalloc_u
#define FREE   free_u
#define CFREE  cfree_u
#define Element Element2

#define DOC_cappoint "[PARSER.SRC.DOC]cappoint.i"
#define DOC_charclas "[PARSER.SRC.DOC]charclas.i"
#define DOC_mapi     "[PARSER.SRC.DOC]map.i"
#define DOC_mapext   "[PARSER.SRC.DOC]map.ext"
#define DOC_entity   "[PARSER.SRC.DOC]entity.i"
#define DOC_incli    "[PARSER.SRC.DOC]incl.i"
#define DOC_inclext  "[PARSER.SRC.DOC]incl.ext"
#define DOC_taglist  "[PARSER.SRC.DOC]taglist.i"
#define DOC_tags     "[PARSER.SRC.DOC]tags.i"
#define DOC_att_pari "[PARSER.SRC.DOC]att_par.i"
#define DOC_att_parext "[PARSER.SRC.DOC]att_par.ext"

#else
#define DOC_cappoint "DOC/cappoint.i"
#define DOC_charclas "DOC/charclas.i"
#define DOC_mapi     "DOC/map.i"
#define DOC_mapext   "DOC/map.ext"
#define DOC_entity   "DOC/entity.i"
#define DOC_incli    "DOC/incl.i"
#define DOC_inclext  "DOC/incl.ext"
#define DOC_taglist  "DOC/taglist.i"
#define DOC_tags     "DOC/tags.i"
#define DOC_att_pari "DOC/att_par.i"
#define DOC_att_parext "DOC/att_par.ext"
#endif

/*
 *  Undefine DEBUG, if no debug-code must be generated.
 */
#define DEBUG

#ifdef DEBUG
#define FLUSH fflush(fpdg);
#define DEB(f)                 if(debug){ fprintf(fpdg,f);                FLUSH}
#define DEB1(f,a1)             if(debug){ fprintf(fpdg,f,a1);             FLUSH}
#define DEB2(f,a1,a2)          if(debug){ fprintf(fpdg,f,a1,a2);          FLUSH}
#define DEB3(f,a1,a2,a3)       if(debug){ fprintf(fpdg,f,a1,a2,a3);       FLUSH}
#define DEB4(f,a1,a2,a3,a4)    if(debug){ fprintf(fpdg,f,a1,a2,a3,a4);    FLUSH}
#define DEB5(f,a1,a2,a3,a4,a5) if(debug){ fprintf(fpdg,f,a1,a2,a3,a4,a5); FLUSH}
#else
#define FFLUSH
#define DEB(f)
#define DEB1(f,a1)
#define DEB2(f,a1,a2)
#define DEB3(f,a1,a2,a3)
#define DEB4(f,a1,a2,a3,a4)
#define DEB5(f,a1,a2,a3,a4,a5)
#endif

typedef char*			String;

#include "tools.h"
#include "assert.h"

#ifdef DEBUG
extern FILE *fpdg; /* debug file */
#endif

#define  NAMECASE_GENERAL  (1)    /* See standard page 50 */
#define  NAMECASE_ENTITY   (0)    /* See standard page 50 */

#define  Token            int
#define  Delimiter        int
#define  RecognitionMode  int
#define  Constraint       int

/*typedef for pointertypes, so other files don't know the structure */
typedef struct attdef_struct*   P_Attdef;
typedef struct attlist_struct*  P_Attlist;
typedef struct attdef_struct*   P_Attdeflist;
typedef P_Attdef                P_Att_iter;

typedef struct extern_id_struct*     P_Extern_id;
typedef struct map_struct*           P_Map;
typedef struct parsertable_struct*   Parserinfo;
typedef struct element_struct*       P_Element;
typedef struct reference_struct*     P_Reference;
typedef struct link_struct*          P_Group;
typedef struct link_struct*          P_Iterator;
typedef struct node_struct*          P_Node;
typedef struct set_struct*           P_Set;
typedef struct setiter_struct*       P_Set_iterator;

typedef struct replace_struct*       P_Replace;
typedef struct chunk_struct*         P_Chunk;

typedef  int  (*IntFunction         )(PAR       RAP);
typedef  int  (*IntFunctionInt      )(PAR  int  RAP);
typedef  int  (*IntFunctionIntInt   )(PAR  int, int  RAP);
typedef  int  (*IntFunctionVoidVoid )(PAR  void*, void*  RAP);
typedef  void (*VoidFunctionInt     )(PAR  int  RAP);
typedef  void (*P_Node_func         )(PAR  P_Node, P_Element  RAP);

#include "report.h"

/*  Definitions for occurence indicators and connectors.
 *  Could be enumeration types, but that's not K&R.
 */
#define   OCC_OPT           700
#define   OCC_REP           701
#define   OCC_PLUS          702
#define   CONN_SEQ          703
#define   CONN_OR           704
#define   CONN_AND          705

#define   is_connector(c)   ((c==CONN_AND) or (c==CONN_OR) or (c==CONN_SEQ))
#define   is_occurrence(c)  ((c==OCC_OPT ) or (c==OCC_REP) or (c==OCC_PLUS))

#define iterator_next(it)	       iter_next(&it)
#define iterator_previous(it)	       iter_previous(&it)
#define next_node(it)       (P_Node   )iter_next(&it)
#define previous_node(it)   (P_Node   )iter_previous(&it)
#define next_name(it)       (String   )iter_next(&it)
#define next_element(it)    (P_Element)iter_next(&it)
#define next_chunk(it)      (P_Chunk  )iter_next(&it)

#define Yes       1
#define No        2
#define Undecided 3

#define   SH_REF     1
#define   NR_SH_REFS 32

#define   DOCUMENT   "document"

#define   GENERAL    601
#define   PARAMETER  602
#define   GI         603
#define   LITERAL    604
#define   EXTERNAL   605
#define   ENUMERATE  606
#define   GROUP      607
#define   KEY        608
#define   NO_OCC     609
#define   GI_START   610
#define   GI_END     611
#define   GI_NAME    612
#define   NOTUSED    613

#define   UNDEFINED	0

/*  Definitions for the keywords of SGML
 */
#define   ENTITY	1
#define   DOCTYPE	2
#define   ELEMENT	3
#define   ATTLIST	4
#define   NOTATION	5
#define   SHORTREF	6
#define   USEMAP	7
#define   LINKTYPE	8
#define   LINK		9
#define   USELINK	10
#define   RS		11
#define   RE		12
#define   SPACE		13
#define   SYSTEM	14
#define   PUBLIC	15
#define   TEMP		16
#define   CDATA		17
#define   IGNORE	18
#define   INCLUDE	19
#define   RCDATA	20
#define   DEFAULT	21
#define   SDATA		22
#define   PI		23
#define   STARTTAG	24
#define   ENDTAG	25
#define   MS		26
#define   MD		27
#define   SUBDOC	28
#define   NDATA		29
#define   EMPTY		30
#define   ANY		31
#define   PCDATA	32
#define   ID		33
#define   IDREF		34
#define   IDREFS	35
#define   NAME		36
#define   NAMES		37
#define   NMTOKEN	38
#define   NMTOKENS	39
#define   NUMBER	40
#define   NUMBERS	41
#define   NUTOKEN	42
#define   NUTOKENS	43
#define   FIXED		44
#define   REQUIRED	45
#define   CURRENT	46
#define   CONREF	47
#define   IMPLIED	48
#define   SIMPLE	49
#define   XPCDATA	50
#define   SGML		51
#define   FUNCHAR	52
#define   MSOCHAR	53
#define   MSICHAR	54
#define   MSSCHAR	55
#define   SEPCHAR	56

/* quantities used in the SGML-declaration, constant for capacity value
 */
#define  CAP_VAL	35000
#define  ATTCNT		40
#define  ATTSPLEN	960
#define  BSEQLEN	960
#define  ENTLVL		16
#define  GRPCNT		32
#define  GRPGTCNT	96
#define  GRPLVL		16
#define  LITLEN		240
#define  NAMELEN	8
#define  NORMSEP	2
#define  PILEN		240
#define  TAGLEN		960
#define  TAGLVL		24
#define  DATALEN	500
#endif
