C Parallel Scheduler, Version 1.1, 04/27/90
C



	integer function ttcost(t1, t2, tuples)
	integer cost, t1, t2, tuples(300, 5)

	cost = 0
	if(tuples(t1, 1) .eq. tuples(t2, 1)) cost = cost + 1
	if(tuples(t1, 3) .eq. tuples(t2, 3)) cost = cost + 1
	if(tuples(t1, 4) .eq. tuples(t2, 4)) cost = cost + 1
	ttcost = cost
	return
	end



	integer function tpcost(tuples, tuple, period, sch, size)
	integer i, cost, ttcost
	integer tuples(300, 5), tuple, period, sch(30, 30), size

	cost = 0
	do 5 i=1, size
 5	   cost = cost + ttcost(tuple, sch(period, i), tuples)
	tpcost = cost
	return
	end



C Since a period's cost matrix is symmetric only the upper triangle
C is considered.
C
	integer function ppcost(tuples, period, sch, size)
	integer i, j, cost, ttcost
	integer tuples(300, 5), period, sch(30, 30), size

	cost = 0
	do 5  i=1, size
	do 5  j=i+1, size
 5	   cost = cost + ttcost(sch(period, i), sch(period, j), tuples)
	ppcost = cost
	return
	end



	logical function accept(seed, delta, temp)
	integer seed, delta
	real    temp, ran

	if(delta .le. 0) goto 5
	accept = (exp(float(- delta) / temp) .gt. ran(seed))
	goto 10
 5	accept = .true.
 10	return
	end



C A from period (nonempty), a tuple in that period, and a to period
C (not the from period) are choosen at random. Then the energy gain
C of removing the tuple from the from period,and the energy lost of
C adding the tuple to the to period are computed.
C
	subroutine getswap(seed, to, from, index, tuple, sch, psize)
	real    ran
	integer seed, to, from, index, tuple
	integer sch(30, 30), psize(30)

 5	from = ifix(ran(seed) * 30.0) + 1
	if(psize(from) .eq. 0) goto 5

 10	to   = ifix(ran(seed) * 30.0) + 1
	if(from .eq. to) goto 10

	index = ifix(ran(seed) * psize(from)) + 1
	tuple = sch(from, index)

	return
	end



C A tuple from period, and a to period (not the  from  period)  are
C choosen at random. The change in energy due to the swap is calcu-
C lated and the Boltzmann function is called to decide  whether  or
C not to accept the swap.  Note the energy calculated may be incor-
C rect due to simultaneous swaps.
C
	subroutine swapset(seed, to, index, tuple, temp,
     \                     swaps, success, tuples, sch, psize)
	real    temp, ran
	logical accept
        integer i, delta, tpcost
	integer seed, to(30), index(30), tuple(30)
	integer swaps, success
	integer tuples(300, 5), sch(30, 30), psize(30)

	do 10 i=1, 30
	   if(psize(i) .eq. 0) goto 6
 3	   to(i) = ifix(ran(seed) * 30.0) + 1
	   if(to(i) .eq. i) goto 3
	   index(i) = ifix(ran(seed) * float(psize(i))) + 1
	   if(index(i) .gt. psize(i)) print *, i
	   tuple(i) = sch(i, index(i))
           delta =
     \         tpcost(tuples, tuple(i), to(i), sch, psize(to(i)))
     \       - tpcost(tuples, tuple(i), i, sch, psize(i)) + 3
	   if(.not. (accept(seed, delta, temp))) goto 5
 4	   swaps    = swaps + 1
	   success  = success + 1
	   goto 10
 5	   to(i)    = 0
	   index(i) = 0
	   tuple(i) = 0
	   swaps    = swaps + 1
	   goto 10
 6	   to(i)    = 0
	   index(i) = 0
	   tuple(i) = 0
 10	continue
	return
	end



C Remove the tuple from the From period, and add the tuple to the To
C period (note, the From and To are guaranteed to be different. Then
C Update Energy, and Schedule.
C
	subroutine updatestate(to, from, index,
     \                         tuple, energy, tuples, sch, psize)
        integer Er, Ea, tpcost
	integer to, from, index, tuple, energy
        integer tuples(300, 5), sch(30, 30), psize(30)

	sch(from, index) = sch(from, psize(from))
	sch(from, psize(from)) = 0
        psize(from) = psize(from) - 1
        Er = tpcost(tuples, tuple, from, sch, psize(from))
	Ea = tpcost(tuples, tuple, to, sch, psize(to))
        energy = energy - Er + Ea
        sch(to, psize(to) + 1) = tuple
        psize(to) = psize(to) + 1
	return
	end



	integer function gbcost(tuples, sch, psize)
	integer i, cost, ppcost
	integer tuples(300, 5), sch(30, 30), psize(30)

	cost = 0
	do 5 i=1,30
 5	   cost = cost + ppcost(tuples, i, sch, psize(i))
	gbcost = cost
	return
	end



C Return the starting energy, temperature, schedule. The starting temp-
C erature is the standard deviation of the energy over N swaps.   Each
C swap is accepted without regard to the resulting change in energy.
C
	subroutine initschedule(msuccess, seed, 
     \                          energy, temp, tuples, sch, psize)
	real    avg, avg2
	integer i, sumE, sumE2, to, from, index, tuple
	real    temp
	integer msuccess, seed, energy
	integer tuples(300, 5), sch(30, 30), psize(30)

	sumE  = 0
	sumE2 = 0
	do 5 i=1, msuccess
	   call getswap(seed, to, from, index, tuple, sch, psize)
           call updatestate(to, from, index,
     \                      tuple, energy, tuples, sch, psize)
	   sumE  = sumE + energy
 5	   sumE2 = sumE2 + (energy * energy)

	avg  = float(sumE)  / float(msuccess + 1)
	avg2 = float(sumE2) / float(msuccess + 1)
	temp = sqrt(avg2 - (avg * avg))

	return
	end



C Divides tuples into periods, calculates and returns starting schedule,
C annealing temperature, global cost, a initial set of error tuples.
C
	subroutine initialize(mperiods, msuccess,
     \                        seed, tuples, E, T, sch, psize)
        integer i, j, gbcost
	real    T
	integer mperiods, msuccess, seed
	integer tuples(300,5), E, sch(30,30), psize(30)

	do 5 i=1,30
	   psize(i) = 10
	do 5 j=1,10
 5	   sch(i, j) = ((i - 1) * 10) + j

	E = gbcost(tuples, sch, psize)

	call initschedule(msuccess, seed, E, T, tuples, sch, psize)

	return
	end



C Anneals the schedule at the current temperature until the stopping
C conditions are met;returns a new schedule, set of error tuples and
C global cost.
C
	subroutine anneal(mswaps, msuccess, seed, energy,
     \                    temp, swaps, success, tuples, sch, psize)
        real    temp
	integer to(30), index(30), tuple(30)
	integer mswaps, msuccess, seed, energy, swaps, success
        integer tuples(300, 5), sch(30, 30), psize(30)

 5	if((swaps .ge. mswaps) .or.
     \     (success .ge. msuccess) .or. (energy .eq. 0)) goto 15
           call swapset(seed, to, index, tuple, temp,
     \                  swaps, success, tuples, sch, psize)
           do 10 i=1, 30
	      if(to(i) .eq. 0) goto 10
	      call updatestate(to(i), i, index(i),
     \                         tuple(i), energy, tuples, sch, psize)
 10        continue
   	goto 5
 15	continue
	return
	end



C Anneal the schedule until the ground state is reached or no change
C occurs for five temperatures. The temperature decreases by .9 each
C iteration.
C
	subroutine scheduler(mclasses, mrooms, msubjects, mteachers,
     \                       mswaps, msuccess, seed, tuples, T, E,
     \                       swaps, success, sch, psize)
	integer i, mperiods, nochange
	real    T(1000)
	integer mclasses, mrooms, msubjects
	integer mteachers, mswaps, msuccess, seed
        integer tuples(300, 5), E(1000)
        integer swaps(1000), success(1000), sch(30, 30), psize(30)

	mperiods = 30

        i        =  1
	nochange =  0

	call initialize(mperiods, msuccess, seed,
     \                  tuples, E(1), T(1), sch, psize)

 5	if((E(i) .eq. 0) .or. (nochange .ge. 5)) goto 20

        i    = i + 1
        E(i) = E(i - 1)
        T(i) = 0.9 * T(i - 1)
        call anneal(mswaps, msuccess, seed, E(i), T(i),
     \              swaps(i), success(i), tuples, sch, psize)

	if(E(i) .ne. E(i-1)) goto 10
	nochange = nochange + 1
	goto 15
 10	nochange = 0

 15	goto 5

 20	return
	end

C Runs the scheduler on the input data for each seed. Returns the min-
C imum, maximum, and total number of swaps;  the termperature, energy,
C number of swaps, number of successes, period cost,  and period size
C array for each run.
C
	program PSA
        integer i, iter, Tswaps, ppcost, psize(30), pcost(30)
	integer mclasses, mrooms, msubjects, mteachers
	integer seed1, seed2, mswaps, msuccess
	integer tuples(300, 5)
        real    T(1000)
        integer E(1000), swaps(1000), success(1000), sch(30, 30)
	data    T, E/1000*0.0, 1000*0/
	data    swaps, success, sch, psize/1000*0, 1000*0, 900*0, 30*0/

	read *, mclasses, mrooms, msubjects, mteachers
	read *, seed1, seed2
	read *, mswaps, msuccess
	do 1 i = 1,300
 1	   read *, (tuples(i, j), j=1, 5)

	call time1

	call scheduler(mclasses, mrooms, msubjects, mteachers,
     \                 mswaps, msuccess, seed1, tuples, T, E,
     \                 swaps, success, sch, psize)

	call time2

	iter = 1
 5	if(T(iter + 1) .eq. 0.0) goto 10
	iter = iter + 1
	goto 5
 10	print *, iter - 1

	print *, E(iter)

        Tswaps = 0
	do 15 i = 2,iter
 15	   Tswaps = Tswaps + swaps(i)
	print *, Tswaps

	do 20 i = 1,30
 20	   pcost(i) = ppcost(tuples, i, sch, psize(i))

	do 25 i = 2,iter,5
 25	   print *, (T(i+j), j = 0,4)

	do 30 i = 2,iter,5
 30	   print *, (E(i+j), j = 0,4)

	do 35 i = 2,iter,5
 35	   print *, (swaps(i+j), j = 0,4)

	do 40 i = 2,iter,5
 40	   print *, (success(i+j), j = 0,4)

	do 45 i = 1,30,5
 45	   print *, (psize(i+j), j = 0,4)

	do 50 i = 1,30,5
 50	   print *, (pcost(i+j), j = 0,4)

	stop
	end

