# Beth example configuration file
# Illustrates some useful configs. To use this, copy it to ~/.beth

# When searching, the text found is graced with the search tag, but the
# search tag carries no configurations to highlight it. Here's one:
$text tag configure search -background gold

# When a close paren/bracket/brace is hit, in balancebind, the matching open
# paren/bracket/brace is graced with the balance tag, but the balance tag
# carries no configurations to hightlight it. Here's one:
$text tag configure balance -background magenta

# $frame.fpl contains the file path, which is set to the current directory.
# The following command 'toggles' the label, so the file path is hidden, you
# can reveal it again by clicking mousebutton 1 on it. This saves space
# in the $frame widget.
catch {label_expand_toggle $frame.fpl fsBox(path)}

# When should balancebind.tcl be loaded? The following command loads it
# for every Beth instance.
set balance_list {{\( \) parenright} {\[ \] bracketright} {\{ \} braceright}}
source $beth_dir/balancebind.tcl

# When should textbind.tcl be loaded?
# The following code loads textbind.tcl iff the option is a file that has
# either no extension, or an extension of .tmp or .txt
if {(![string match \|* $option]) &&
	(([file extension $option] == "") ||
	([file extension $option] == ".tmp") ||
	([file extension $option] == ".txt"))} {
		source $beth_dir/textbind.tcl
}

# Which file prompter should be used?
# This code loads up Sven Delmas's FSBox code, to use Beth's own file prompter
# comment out these lines:
if $edit_flag {
	set path $fsBox(path);	set name $fsBox(name)
	source $beth_dir/file.tcl
	set fsBox(path) $path;	set fsBox(name) $name
	set file_prompter FSBox
}
