# Bindings for file I/O


# Opens up $path/$name or just $name if it is a command pipeline, and
# dumps contents of text widget t into it.
proc write_file {t f path name} {
	if {([string match \|* $name])} {
		set file [open $name" w]
	} else {set file [open $path/$name w]}
	puts $file [$t get 1.0 end] nonewline
	close $file
}

proc default_file_prompter {msg} {
	global file_done fsBox text frame
	set name $fsBox(name)
	create_f_entry $text $frame.filel $frame.filee
	$frame.filel configure -text $msg
	if {(![string match \|* $name])} {$frame.filee insert 0 $fsBox(path)/}
	set index [$frame.filee index insert]
	$frame.filee insert $index $name
	$frame.filee icursor $index
	$frame.filee view [expr $index - [lindex [$frame.filee configure -width] 4]]
	bind $frame.filee <Return> "set file_done 1"
	bind $frame.filee <KP_Enter> "[bind $frame.filee <Return>]"
	bind $frame.filee <Control-g> "set file_done 2"
	global file_done cwd;	set file_done 0
	tkwait variable file_done
	set what [$frame.filee get]
	destroy_f_entry $text $frame.filel $frame.filee
	if {$file_done == 2} {
		beep
		set fsBox(name) ""
		return 0}
	if {([string match \|* $what]) || ([file dirname $what] == ".")} {
		set fsBox(path) $cwd
		set fsBox(name) $what
	} else {set fsBox(path) [file dirname $what]
		set fsBox(name) [file tail $what]
	}
	return 1
}

# Get the path/file via a file prompting widget.
proc file_prompt {msg f} {
	global fsBox file_prompter
	set path $fsBox(path) ; set name $fsBox(name)
	set grab_status [grab status .] 
	$file_prompter $msg
	if {($grab_status != "none")} {take_control $f}
	if {($fsBox(name) == "")} {
		set fsBox(path) $path;	set fsBox(name) $name
		return 0}
	set fsBox(name) [string trimright $fsBox(name) "*/"]
	return 1
}


# File Messages
set confirm_save_msg " has been modified. Do you want to save it first?"
set save_msg "Select a file to save"
set read_msg "Select a file to read"
set mutual_edit_conflict_msg " is being editied by another interpreter. What should I do?"

# Variable to determine if file needs saving. (also set in editbind.tcl)
set modified 0

# Confirm if user wants to save the file.
proc save_confirm {default t f} {
	global modified confirm_save_msg fsBox
	set message "$fsBox(name) $confirm_save_msg"
	if {($modified == 1)} {
		set choice [tk_dialog .conf "Save Dialog" $message question 0 "Save" "Don't Save" "Cancel"]
		if {($choice == 0)} {save_file $t $f}
		if {($choice == 2)} {return 0} else {return 1}
}}

# Time we last accessed this file. (generally shortly after startup time)
after 1000 {catch {set atime [file mtime $fsBox(path)/$fsBox(name)]}}

proc save_file {t f} {
	global fsBox save_msg last_io
	if {($fsBox(name) == "") || ([string match \|* $fsBox(name)] &&
					($last_io == "read"))} {
		if {[save_file_prompt $t $f] == 0} {return 0}}
	if {([$t get {end -1 chars}] != "\n")} {$t insert end "\n"}
	write_file $t $f $fsBox(path) $fsBox(name)
	global modified atime;	set modified 0
	catch {set atime [file mtime $fsBox(path)/$fsBox(name)]}
	global title_comment
	reset_my_title "Edit: $fsBox(name) $title_comment" "E $fsBox(name) $title_comment"
	check_for_duplicate_interps $t $f $fsBox(path) $fsBox(name)
	return 1
}

# Set to read or write depending on last operation performed.
set last_io "read"

proc save_file_prompt {t f} {
	global save_msg last_io
	if {([file_prompt $save_msg $f] == 0)} {return 0}
	set last_io "write"
	save_file $t $f
	return 1
}

proc revert_file {t f} {
	global fsBox read_msg last_io modified atime
	if {([save_confirm 1 $t $f] == 0)} {return}
	if {($fsBox(name) == "") || ([string match \|* $fsBox(name)] &&
					($last_io == "write"))} {
		set old_modified $modified
		set modified 0
		if {[read_file $t $f] == 0} {
			set modified $old_modified
			set return 0}}
	load_file $t $f $fsBox(path) $fsBox(name)
	catch {set atime [file mtime $fsBox(path)/$fsBox(name)]}
	global title_comment
	reset_my_title "Edit: $fsBox(name) $title_comment" "E $fsBox(name) $title_comment"
	check_for_duplicate_interps $t $f $fsBox(path) $fsBox(name)
	$t yview 1.0 ; $t mark set insert 1.0
	focus $t
	set modified 0
	return 1
}

proc read_file {t f} {
	global read_msg last_io modified
	if {([save_confirm 1 $t $f] == 0)} {return}
	set old_modified $modified
	set modified 0
	if {([file_prompt $read_msg $f] == 0)} {
		set modified $old_modified
		return 0}
	set last_io "read"
	revert_file $t $f
	set modified 0
	return 1
}

proc visit_file {f} {
	global fsBox read_msg
	set path $fsBox(path);	set name $fsBox(name)
	if {([file_prompt $read_msg $f] == 0)} {return}
	set int [exec beth $fsBox(path)/$fsBox(name) &]
	set fsBox(path) $path;	set fsBox(name) $name
	if {([grab status .] != "none")} {
		relinquish_control $f 
		send $int take_control $f
}}

# Set modified if file has been modified since we last read/saved it.
proc check_mtime {} {
	global atime modified fsBox
	if {[catch {set atime}]} {return}
	if {[string match \|* $fsBox(name)]} {return}
	if {[catch {file mtime $fsBox(path)/$fsBox(name)}]} {set modified 1 ; return}
	if {([file mtime $fsBox(path)/$fsBox(name)] > $atime)} {set modified 1
}}


# Mutual file exclusion.

# Waits until all interps have titles differing from their interpreter names.
proc resolve_all_titles {} {
	global all_titles all_interps
	set l [llength $all_interps]
	while 1 {
		set all_resolved 1
		set titles $all_titles
		for {set i 0} {$i < $l} {incr i} {
			if {([lindex $all_interps $i] == [lindex $all_titles $i])} {
				set all_resolved 0
		}}
		if $all_resolved break
		if {$all_titles == $titles} {	tkwait variable all_titles
}}}

# Ensures no other interp is editing the same file I am editing.
proc check_for_duplicate_interps {t f path name} {
	global all_interps all_titles me
	set interps $all_interps;	set titles $all_titles
	set my_title [wm title .]

	# This seems to help:
	after 100

	for {set i 0} {$i < [llength $interps]} {incr i} {
		set him [lindex $interps $i]
		set his_title [lindex $titles $i]
		if {($my_title == $his_title)} {

			# Oh...it's just me.
			if {($me == $him)} {break}

			# If we're looking at a pipe output, stdin, or
			# X selection, don't bother.
			if {[string match \|* $name] || ($name == "-") || ($name == "X") || ($name == "=")} {break}

			# Maybe he can only browse. Fine.
			if {(![send $him "set edit_flag"])} {break}

			# Maybe he's looking in a different directory.
			if {($path != [send $him "set fsBox(path)"])} {break}

			# Oh well...gotta resolve it.
			resolve_mutual_edit_conflict $him "$path/[lindex $my_title 1]" $t $f
}}}

proc resolve_mutual_edit_conflict {him file t f} {
	global mutual_edit_conflict_msg
	set message "$file $mutual_edit_conflict_msg"
	set choice [tk_dialog .conf "Interpreter Dialog" $message warning \
      		0 "Quit" "Read another file" "Kill other interpreter" "Nothing"]
	if {($choice == 0)} {after 1000 quit_beth
	} elseif {($choice == 1)} {read_file $t $f
	} elseif {($choice == 2)} {catch {send $him {quit_beth
}}}}

# Confirm file saving on quit (a redefinition of quit_beth)
proc quit_beth {} {
	global quit_hook text frame
	if {([save_confirm 1 $text $frame] == 0)} {return}
	if {[info exists quit_hook]} {eval $quit_hook}
	exit
}


# File bindings. f is a frame widget to put messages in.
proc filebind {f} {
	bind Text <Control-g> "+catch \{destroy_f_entry %W $f.filel $f.filee\}"

	bind Text <Meta-R> "revert_file %W $f"
	bind Text <Meta-S> "save_file_prompt %W $f"
	bind Text <Meta-r> "read_file %W $f"
	bind Text <Meta-s> "save_file %W $f"
	bind Text <Meta-Control-v> "visit_file $f"
	bind . <Any-Enter> "check_mtime"
}

filebind $frame

# Create file path label
catch {destroy $frame.fpl}
label $frame.fpl -relief flat -anchor e
label_expand_bind $frame.fpl fsBox(path)

# Create file name label
catch {destroy $frame.fnl}
label $frame.fnl -relief flat
label_expand_bind $frame.fnl fsBox(name)

pack $frame.fpl $frame.fnl -side left

# Ensure we're not editing file another beth interp is editing.
if {(![info exists file_prompter])} {set file_prompter default_file_prompter}
after 1 {resolve_all_titles
	if {[info exists name]} {
	check_for_duplicate_interps $text $frame $path \"$name\"}}
