'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_Backslash.man,v 1.4 89/05/18 16:29:01 ouster Exp $ SPRITE (Berkeley)
'\" 
.so \*(]ltmac.sprite
.HS Tcl_Backslash tcl
.BS
.SH NAME
Tcl_Backslash \- parse a backslash sequence
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
char
\fBTcl_Backslash\fR(\fIsrc, countPtr\fR)
.SH ARGUMENTS
.AP char *src in
Pointer to a string starting with a backslash.
.AP int *countPtr out
If \fIcountPtr\fR isn't NULL, \fI*countPtr\fR gets filled
in with number of characters in the backslash sequence, including
the backslash character.
.BE

.SH DESCRIPTION
.PP
This is a utility procedure used by several of the Tcl
commands.  It parses a backslash sequence and returns
the single character corresponding to the sequence.
\fBTcl_Backslash\fR modifies \fI*countPtr\fR to contain the number of characters in
the backslash sequence.  If \fIsrc\fR doesn't point to a backslash
sequence understood by Tcl, then Tcl_Backslash returns a backslash
as its result and \fI*countPtr\fR gets set to 1 (in this case the
backslash character should not get any special treatment).
.PP
See the Tcl manual entry for information on the valid
backslash sequences.  All of the sequences described in the Tcl
.VS
manual entry are supported by \fBTcl_Backslash\fR except
backslash-newline, which is not understood.
.VE

.SH KEYWORDS
backslash, parse
