/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import tcl.lang.Command;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.JACL;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

class FileCmd
implements Command {
    static Class procClass = null;
    private static final String[] validCmds = new String[]{"atime", "copy", "delete", "dirname", "executable", "exists", "extension", "isdirectory", "isfile", "join", "lstat", "mtime", "mkdir", "owned", "pathtype", "readable", "readlink", "rename", "rootname", "size", "split", "stat", "tail", "type", "writable"};
    static final int OPT_ATIME = 0;
    static final int OPT_COPY = 1;
    static final int OPT_DELETE = 2;
    static final int OPT_DIRNAME = 3;
    static final int OPT_EXECUTABLE = 4;
    static final int OPT_EXISTS = 5;
    static final int OPT_EXTENSION = 6;
    static final int OPT_ISDIRECTORY = 7;
    static final int OPT_ISFILE = 8;
    static final int OPT_JOIN = 9;
    static final int OPT_LSTAT = 10;
    static final int OPT_MTIME = 11;
    static final int OPT_MKDIR = 12;
    static final int OPT_OWNED = 13;
    static final int OPT_PATHTYPE = 14;
    static final int OPT_READABLE = 15;
    static final int OPT_READLINK = 16;
    static final int OPT_RENAME = 17;
    static final int OPT_ROOTNAME = 18;
    static final int OPT_SIZE = 19;
    static final int OPT_SPLIT = 20;
    static final int OPT_STAT = 21;
    static final int OPT_TAIL = 22;
    static final int OPT_TYPE = 23;
    static final int OPT_WRITABLE = 24;
    private static final String[] validOptions = new String[]{"-force", "--"};
    private static final int OPT_FORCE = 0;
    private static final int OPT_LAST = 1;

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 3) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option name ?arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], validCmds, "option", 0);
        File file = null;
        switch (n) {
            case 0: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                file = FileUtil.getNewFileObj(interp, tclObject.stringRep);
                tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                int n2 = FileCmd.getMtime(interp, tclObject.stringRep, file);
                interp.setResult(TclInteger.newInstance(n2));
                return;
            }
            case 1: {
                FileCmd.fileCopyRename(interp, tclObjectArray, true);
                return;
            }
            case 2: {
                FileCmd.fileDelete(interp, tclObjectArray);
                return;
            }
            case 3: {
                String string;
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                TclObject[] tclObjectArray2 = tclObjectArray[2];
                if (tclObjectArray2.stringRep == null) {
                    tclObjectArray2.stringRep = tclObjectArray2.internalRep.toString();
                }
                if ((tclObjectArray2 = TclList.getElements(interp, FileUtil.splitAndTranslate(interp, string = tclObjectArray2.stringRep))).length > 1) {
                    String string2 = FileUtil.joinPath(interp, tclObjectArray2, 0, tclObjectArray2.length - 1);
                    if (string2 == null) {
                        interp.resetResult();
                        return;
                    }
                    interp.setResult(TclString.newInstance(string2));
                    return;
                }
                if (tclObjectArray2.length == 0 || FileUtil.getPathType(string) == 0) {
                    if (JACL.PLATFORM == 2) {
                        if (":" == null) {
                            interp.resetResult();
                            return;
                        }
                        interp.setResult(TclString.newInstance(":"));
                        return;
                    }
                    if ("." == null) {
                        interp.resetResult();
                        return;
                    }
                    interp.setResult(TclString.newInstance("."));
                    return;
                }
                Object object = tclObjectArray2[0];
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                if ((object = ((TclObject)object).stringRep) == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)object));
                return;
            }
            case 4: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                boolean bl = false;
                Object object = tclObjectArray[2];
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                if ((file = FileUtil.getNewFileObj(interp, ((TclObject)object).stringRep)).exists()) {
                    bl = file.isDirectory();
                    if (bl) {
                        interp.setResult(TclBoolean.newInstance(bl));
                        return;
                    }
                    if (Util.isWindows()) {
                        object = tclObjectArray[2];
                        if (((TclObject)object).stringRep == null) {
                            ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                        }
                        bl = ((String)(object = ((TclObject)object).stringRep)).endsWith(".exe") || ((String)object).endsWith(".com") || ((String)object).endsWith(".bat");
                    } else {
                        bl = Util.isMac() ? true : true;
                    }
                }
                interp.setResult(TclBoolean.newInstance(bl));
                return;
            }
            case 5: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                file = FileUtil.getNewFileObj(interp, tclObject.stringRep);
                boolean bl = file.exists();
                interp.setResult(TclBoolean.newInstance(bl));
                return;
            }
            case 6: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                Object object = tclObjectArray[2];
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                if ((object = FileCmd.getExtension(((TclObject)object).stringRep)) == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)object));
                return;
            }
            case 7: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                file = FileUtil.getNewFileObj(interp, tclObject.stringRep);
                boolean bl = file.isDirectory();
                interp.setResult(TclBoolean.newInstance(bl));
                return;
            }
            case 8: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                file = FileUtil.getNewFileObj(interp, tclObject.stringRep);
                boolean bl = file.isFile();
                interp.setResult(TclBoolean.newInstance(bl));
                return;
            }
            case 9: {
                String string = FileUtil.joinPath(interp, tclObjectArray, 2, tclObjectArray.length);
                if (string == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance(string));
                return;
            }
            case 10: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name varName");
                }
                StringBuffer stringBuffer = new StringBuffer("file command with opt ");
                TclObject tclObject = tclObjectArray[1];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                throw new TclException(interp, stringBuffer.append(tclObject.stringRep).append(" is not yet implemented").toString());
            }
            case 12: {
                FileCmd.fileMakeDirs(interp, tclObjectArray);
                return;
            }
            case 11: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                file = FileUtil.getNewFileObj(interp, tclObject.stringRep);
                tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                int n3 = FileCmd.getMtime(interp, tclObject.stringRep, file);
                interp.setResult(TclInteger.newInstance(n3));
                return;
            }
            case 13: {
                boolean bl;
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                if (!(file = FileUtil.getNewFileObj(interp, tclObject.stringRep)).exists()) {
                    bl = false;
                } else {
                    boolean bl2 = !Util.isMac() && !Util.isWindows();
                    bl = true;
                }
                boolean bl3 = bl;
                interp.setResult(TclBoolean.newInstance(bl3));
                return;
            }
            case 14: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                switch (FileUtil.getPathType(tclObject.stringRep)) {
                    case 0: {
                        if ("relative" == null) {
                            interp.resetResult();
                            return;
                        }
                        interp.setResult(TclString.newInstance("relative"));
                        return;
                    }
                    case 1: {
                        if ("volumerelative" == null) {
                            interp.resetResult();
                            return;
                        }
                        interp.setResult(TclString.newInstance("volumerelative"));
                        return;
                    }
                    case 2: {
                        if ("absolute" == null) {
                            interp.resetResult();
                            return;
                        }
                        interp.setResult(TclString.newInstance("absolute"));
                    }
                }
                return;
            }
            case 15: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                file = FileUtil.getNewFileObj(interp, tclObject.stringRep);
                boolean bl = file.canRead();
                interp.setResult(TclBoolean.newInstance(bl));
                return;
            }
            case 16: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                StringBuffer stringBuffer = new StringBuffer("file command with opt ");
                TclObject tclObject = tclObjectArray[1];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                throw new TclException(interp, stringBuffer.append(tclObject.stringRep).append(" is not yet implemented").toString());
            }
            case 17: {
                FileCmd.fileCopyRename(interp, tclObjectArray, false);
                return;
            }
            case 18: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                Object object = tclObjectArray[2];
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                object = ((TclObject)object).stringRep;
                String string = FileCmd.getExtension((String)object);
                int n4 = ((String)object).length() - string.length();
                String string3 = ((String)object).substring(0, n4);
                if (string3 == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance(string3));
                return;
            }
            case 19: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                if (!(file = FileUtil.getNewFileObj(interp, tclObject.stringRep)).exists()) {
                    StringBuffer stringBuffer = new StringBuffer("could not read \"");
                    tclObject = tclObjectArray[2];
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    throw new TclPosixException(interp, 2, true, stringBuffer.append(tclObject.stringRep).append("\"").toString());
                }
                int n5 = (int)file.length();
                interp.setResult(TclInteger.newInstance(n5));
                return;
            }
            case 20: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                interp.setResult(FileUtil.splitPath(interp, tclObject.stringRep));
                return;
            }
            case 21: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name varName");
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                String string = tclObject.stringRep;
                tclObject = tclObjectArray[3];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                FileCmd.getAndStoreStatData(interp, string, tclObject.stringRep);
                return;
            }
            case 22: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                Object object = tclObjectArray[2];
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                if ((object = FileCmd.getTail(interp, ((TclObject)object).stringRep)) == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)object));
                return;
            }
            case 23: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                Object object = tclObjectArray[2];
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                file = FileUtil.getNewFileObj(interp, ((TclObject)object).stringRep);
                object = tclObjectArray[2];
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                if ((object = FileCmd.getType(interp, ((TclObject)object).stringRep, file)) == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)object));
                return;
            }
            case 24: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                file = FileUtil.getNewFileObj(interp, tclObject.stringRep);
                boolean bl = file.canWrite();
                interp.setResult(TclBoolean.newInstance(bl));
                return;
            }
        }
        StringBuffer stringBuffer = new StringBuffer("file command with opt ");
        TclObject tclObject = tclObjectArray[1];
        if (tclObject.stringRep == null) {
            tclObject.stringRep = tclObject.internalRep.toString();
        }
        throw new TclRuntimeError(stringBuffer.append(tclObject.stringRep).append(" is not implemented").toString());
    }

    private static boolean isOwner(Interp interp, File file) throws TclException {
        if (!file.exists()) {
            return false;
        }
        boolean bl = !Util.isMac() && !Util.isWindows();
        return true;
    }

    private static int getMtime(Interp interp, String string, File file) throws TclException {
        if (!file.exists()) {
            throw new TclPosixException(interp, 2, true, "could not read \"" + string + "\"");
        }
        return (int)file.lastModified();
    }

    private static String getType(Interp interp, String string, File file) throws TclException {
        if (!file.exists()) {
            throw new TclPosixException(interp, 2, true, "could not read \"" + string + "\"");
        }
        if (file.isFile()) {
            return "file";
        }
        if (file.isDirectory()) {
            return "directory";
        }
        return "link";
    }

    private static void getAndStoreStatData(Interp interp, String string, String string2) throws TclException {
        File file = FileUtil.getNewFileObj(interp, string);
        if (!file.exists()) {
            throw new TclPosixException(interp, 2, true, "could not read \"" + string + "\"");
        }
        try {
            int n = FileCmd.getMtime(interp, string, file);
            TclObject tclObject = TclInteger.newInstance(n);
            TclObject tclObject2 = TclInteger.newInstance(n);
            TclObject tclObject3 = TclInteger.newInstance(n);
            interp.varFrame.setVar(string2, "atime", tclObject2, 0);
            interp.varFrame.setVar(string2, "ctime", tclObject3, 0);
            interp.varFrame.setVar(string2, "mtime", tclObject, 0);
        }
        catch (SecurityException securityException) {
            throw new TclException(interp, securityException.getMessage());
        }
        catch (TclException tclException) {
            throw new TclException(interp, "can't set \"" + string2 + "(dev)\": variable isn't array");
        }
        try {
            TclObject tclObject = TclInteger.newInstance((int)file.length());
            interp.varFrame.setVar(string2, "size", tclObject, 0);
        }
        catch (Exception exception) {}
        try {
            TclObject tclObject = TclString.newInstance(FileCmd.getType(interp, string, file));
            interp.varFrame.setVar(string2, "type", tclObject, 0);
        }
        catch (Exception exception) {}
        try {
            boolean bl;
            if (!file.exists()) {
                bl = false;
            } else {
                boolean bl2 = !Util.isMac() && !Util.isWindows();
                bl = true;
            }
            TclObject tclObject = TclBoolean.newInstance(bl);
            interp.varFrame.setVar(string2, "uid", tclObject, 0);
            return;
        }
        catch (TclException tclException) {
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static String getExtension(String var0) {
        if (var0.length() < 1) {
            return "";
        }
        var1_1 = -1;
        switch (JACL.PLATFORM) {
            case 1: {
                var2_2 = var0.replace('\\', '/').replace(':', '/');
                var1_1 = var2_2.lastIndexOf(47);
                break;
            }
            case 2: {
                var1_1 = var0.lastIndexOf(58);
                if (var1_1 != -1) break;
                var1_1 = var0.lastIndexOf(47);
                break;
            }
            default: {
                var1_1 = var0.lastIndexOf(47);
            }
        }
        if (++var1_1 >= var0.length()) {
            return "";
        }
        var2_2 = var0.substring(var1_1);
        var3_3 = var2_2.lastIndexOf(46);
        if (var3_3 != -1) ** GOTO lbl23
        return "";
lbl-1000:
        // 1 sources

        {
            --var3_3;
lbl23:
            // 2 sources

            ** while (var3_3 > 0 && var2_2.charAt((int)(var3_3 - 1)) == '.')
        }
lbl24:
        // 1 sources

        return var2_2.substring(var3_3);
    }

    private static String getTail(Interp interp, String string) throws TclException {
        TclObject tclObject = FileUtil.splitAndTranslate(interp, string);
        int n = TclList.getLength(interp, tclObject) - 1;
        if (n >= 0 && (n > 0 || FileUtil.getPathType(string) == 0)) {
            TclObject tclObject2 = TclList.index(interp, tclObject, n);
            if (tclObject2.stringRep == null) {
                tclObject2.stringRep = tclObject2.internalRep.toString();
            }
            return tclObject2.stringRep;
        }
        return "";
    }

    private static void fileMakeDirs(Interp interp, TclObject[] tclObjectArray) throws TclException {
        boolean bl = false;
        int n = 2;
        while (n < tclObjectArray.length) {
            Object object = tclObjectArray[n];
            if (((TclObject)object).stringRep == null) {
                ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
            }
            if (((String)(object = ((TclObject)object).stringRep)).length() == 0) {
                throw new TclPosixException(interp, 2, true, "can't create directory \"\"");
            }
            File file = FileUtil.getNewFileObj(interp, (String)object);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new TclPosixException(interp, 17, true, "can't create directory \"" + (String)object + "\"");
                }
            } else {
                try {
                    bl = file.mkdir();
                    if (!bl) {
                        bl = file.mkdirs();
                    }
                }
                catch (SecurityException securityException) {
                    throw new TclException(interp, securityException.getMessage());
                }
                if (!bl) {
                    throw new TclPosixException(interp, 13, true, "can't create directory \"" + (String)object + "\":  best guess at reason");
                }
            }
            ++n;
        }
    }

    private static void fileDelete(Interp interp, TclObject[] tclObjectArray) throws TclException {
        boolean bl = false;
        int n = 2;
        boolean bl2 = false;
        while (n < tclObjectArray.length && !bl2) {
            TclObject tclObject = tclObjectArray[n];
            if (tclObject.stringRep == null) {
                tclObject.stringRep = tclObject.internalRep.toString();
            }
            if (!tclObject.stringRep.startsWith("-")) break;
            int n2 = TclIndex.get(interp, tclObjectArray[n], validOptions, "option", 1);
            switch (n2) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    bl2 = true;
                    break;
                }
                default: {
                    throw new TclRuntimeError("FileCmd.cmdProc: bad option " + n2 + " index to validOptions");
                }
            }
            ++n;
        }
        if (n >= tclObjectArray.length) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?options? file ?file ...?");
        }
        int n3 = n;
        while (n3 < tclObjectArray.length) {
            TclObject tclObject = tclObjectArray[n3];
            if (tclObject.stringRep == null) {
                tclObject.stringRep = tclObject.internalRep.toString();
            }
            FileCmd.deleteOneFile(interp, tclObject.stringRep, bl);
            ++n3;
        }
    }

    private static void deleteOneFile(Interp interp, String string, boolean bl) throws TclException {
        boolean bl2 = true;
        File file = FileUtil.getNewFileObj(interp, string);
        if (!file.exists() || string.length() == 0) {
            return;
        }
        if (file.isDirectory() && file.list().length > 0) {
            if (bl) {
                String[] stringArray = file.list();
                int n = 0;
                while (n < stringArray.length) {
                    TclObject[] tclObjectArray = new TclObject[]{TclString.newInstance(string), TclString.newInstance(stringArray[n])};
                    String string2 = FileUtil.joinPath(interp, tclObjectArray, 0, 2);
                    FileCmd.deleteOneFile(interp, string2, bl);
                    ++n;
                }
            } else {
                throw new TclPosixException(interp, 66, "error deleting \"" + string + "\": directory not empty");
            }
        }
        try {
            bl2 = file.delete();
        }
        catch (SecurityException securityException) {
            throw new TclException(interp, securityException.getMessage());
        }
        if (!bl2) {
            throw new TclPosixException(interp, 13, true, "error deleting \"" + string + "\":  best guess at reason");
        }
    }

    private static void fileCopyRename(Interp interp, TclObject[] tclObjectArray, boolean bl) throws TclException {
        File file;
        int n = 2;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n < tclObjectArray.length && !bl3) {
            TclObject tclObject = tclObjectArray[n];
            if (tclObject.stringRep == null) {
                tclObject.stringRep = tclObject.internalRep.toString();
            }
            if (!tclObject.stringRep.startsWith("-")) break;
            int n2 = TclIndex.get(interp, tclObjectArray[n], validOptions, "option", 1);
            switch (n2) {
                case 0: {
                    bl2 = true;
                    break;
                }
                case 1: {
                    bl3 = true;
                    break;
                }
                default: {
                    throw new TclRuntimeError("FileCmd.cmdProc: bad option " + n2 + " index to validOptions");
                }
            }
            ++n;
        }
        if (n >= tclObjectArray.length - 1) {
            throw new TclNumArgsException(interp, n, tclObjectArray, "?options? source ?source ...? target");
        }
        int n3 = tclObjectArray.length - 1;
        Object object = tclObjectArray[n3];
        if (((TclObject)object).stringRep == null) {
            ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
        }
        if ((file = FileUtil.getNewFileObj(interp, (String)(object = ((TclObject)object).stringRep))).isDirectory()) {
            int n4 = n;
            while (n4 < n3) {
                Object object2 = tclObjectArray[n4];
                if (((TclObject)object2).stringRep == null) {
                    ((TclObject)object2).stringRep = ((TclObject)object2).internalRep.toString();
                }
                object2 = ((TclObject)object2).stringRep;
                if (((String)object).length() == 0) {
                    FileCmd.copyRenameOneFile(interp, (String)object2, (String)object, bl, bl2);
                } else {
                    String string = FileCmd.getTail(interp, (String)object2);
                    TclObject[] tclObjectArray2 = new TclObject[]{TclString.newInstance((String)object), TclString.newInstance(string)};
                    String string2 = FileUtil.joinPath(interp, tclObjectArray2, 0, 2);
                    FileCmd.copyRenameOneFile(interp, (String)object2, string2, bl, bl2);
                }
                ++n4;
            }
            return;
        }
        if (n + 1 != n3) {
            String string = bl ? "copying" : "renaming";
            StringBuffer stringBuffer = new StringBuffer("error ").append(string).append(": target \"");
            TclObject tclObject = tclObjectArray[n3];
            if (tclObject.stringRep == null) {
                tclObject.stringRep = tclObject.internalRep.toString();
            }
            throw new TclPosixException(interp, 20, stringBuffer.append(tclObject.stringRep).append("\" is not a directory").toString());
        }
        Object object3 = tclObjectArray[n];
        if (((TclObject)object3).stringRep == null) {
            ((TclObject)object3).stringRep = ((TclObject)object3).internalRep.toString();
        }
        object3 = ((TclObject)object3).stringRep;
        FileCmd.copyRenameOneFile(interp, (String)object3, (String)object, bl, bl2);
    }

    private static void copyRenameOneFile(Interp interp, String string, String string2, boolean bl, boolean bl2) throws TclException {
        if (bl2 && string.equals(string2)) {
            return;
        }
        String string3 = bl ? "copying" : "renaming";
        File file = FileUtil.getNewFileObj(interp, string);
        if (!file.exists() || string.length() == 0) {
            throw new TclPosixException(interp, 2, true, "error " + string3 + " \"" + string + "\"");
        }
        if (string2.length() == 0) {
            throw new TclPosixException(interp, 2, true, "error " + string3 + " \"" + string + "\" to \"" + string2 + "\"");
        }
        File file2 = FileUtil.getNewFileObj(interp, string2);
        if (file2.exists() && !bl2) {
            throw new TclPosixException(interp, 17, true, "error " + string3 + " \"" + string + "\" to \"" + string2 + "\"");
        }
        if (file.isDirectory() && !file2.isDirectory()) {
            throw new TclPosixException(interp, 21, "can't overwrite file \"" + string2 + "\" with directory \"" + string + "\"");
        }
        if (file2.isDirectory() && !file.isDirectory()) {
            throw new TclPosixException(interp, 21, "can't overwrite directory \"" + string2 + "\" with file \"" + string + "\"");
        }
        if (!bl) {
            if (!file.renameTo(file2)) {
                throw new TclPosixException(interp, 13, true, "error renaming \"" + string + "\" to \"" + string2 + "\":  best guess at reason");
            }
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                char[] cArray = new char[256];
                int n = 0;
                int n2 = bufferedReader.read(cArray, 0, 256);
                while (n2 != -1) {
                    bufferedWriter.write(cArray, n, n2);
                    n2 = bufferedReader.read(cArray, n += 256, 256);
                }
                bufferedReader.close();
                bufferedWriter.close();
                return;
            }
            catch (Exception exception) {
                throw new TclException(interp, "error copying: " + exception.getMessage());
            }
        }
    }

    FileCmd() {
    }
}

