/*
 * Decompiled with CFR 0.152.
 */
package tcl.regex;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.PatternMatcherInput;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class OroRegsubCmd
implements Command {
    private static final String[] validCmds = new String[]{"-all", "-nocase", "--"};
    private static final int OPT_ALL = 0;
    private static final int OPT_NOCASE = 1;
    private static final int OPT_LAST = 2;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        String origStringArg;
        int objc = argv.length - 1;
        boolean noCase = false;
        boolean all = false;
        boolean last = false;
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 1, argv, "?switches? exp string subSpec varName");
        }
        int currentObjIndex = 1;
        while (objc > 0 && !last) {
            if (!argv[currentObjIndex].toString().startsWith("-")) break;
            int opt = TclIndex.get((Interp)interp, (TclObject)argv[currentObjIndex], (String[])validCmds, (String)"switch", (int)1);
            switch (opt) {
                case 0: {
                    all = true;
                    break;
                }
                case 1: {
                    noCase = true;
                    break;
                }
                case 2: {
                    last = true;
                    break;
                }
                default: {
                    throw new TclException(interp, "RegsubCmd.cmdProc: bad option " + opt + " index to cmds");
                }
            }
            ++currentObjIndex;
            --objc;
        }
        if (objc != 4) {
            throw new TclNumArgsException(interp, 1, argv, "?switches? exp string subSpec varName");
        }
        String patternArg = argv[currentObjIndex].toString();
        String stringArg = origStringArg = argv[currentObjIndex + 1].toString();
        String subSpec = argv[currentObjIndex + 2].toString();
        String varName = argv[currentObjIndex + 3].toString();
        if (noCase) {
            patternArg = patternArg.toLowerCase();
            stringArg = origStringArg.toLowerCase();
        }
        Perl5Matcher matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternArg);
        }
        catch (MalformedPatternException e) {
            throw new TclException(interp, "couldn't compile regular expression pattern:  " + e.getMessage());
        }
        PatternMatcherInput input = new PatternMatcherInput(stringArg);
        StringBuffer sbuf = new StringBuffer(0);
        int numMatches = 0;
        int unmatchedIndex = 0;
        while (matcher.contains(input, pattern)) {
            ++numMatches;
            MatchResult result = matcher.getMatch();
            String tmp = origStringArg.substring(unmatchedIndex, result.beginOffset(0));
            unmatchedIndex = result.endOffset(0);
            sbuf.ensureCapacity(sbuf.length() + tmp.length());
            sbuf.append(tmp);
            int group = -1;
            int nextSpecIndex = -1;
            int first = 0;
            while (first < subSpec.length()) {
                int specIndex = first;
                while (specIndex < subSpec.length()) {
                    block22: {
                        char c = subSpec.charAt(specIndex);
                        if (c == '&') {
                            group = 0;
                            nextSpecIndex = specIndex + 1;
                            break;
                        }
                        if (c == '\\' && specIndex + 1 < subSpec.length()) {
                            c = subSpec.charAt(specIndex + 1);
                            if (Character.isDigit(c)) {
                                group = Character.digit(c, 10);
                                if (group >= result.groups()) {
                                    sbuf.ensureCapacity(sbuf.length() + (specIndex - first));
                                    sbuf.append(subSpec.substring(first, specIndex));
                                    first = specIndex + 2;
                                    ++specIndex;
                                    break block22;
                                } else {
                                    nextSpecIndex = specIndex + 2;
                                    break;
                                }
                            }
                            sbuf.ensureCapacity(sbuf.length() + (specIndex - first) + 1);
                            sbuf.append(String.valueOf(subSpec.substring(first, specIndex)) + c);
                            first = specIndex + 2;
                            ++specIndex;
                        }
                    }
                    ++specIndex;
                }
                if (specIndex < subSpec.length()) {
                    int start = result.beginOffset(group);
                    tmp = start == -1 ? subSpec.substring(first, specIndex) : String.valueOf(subSpec.substring(first, specIndex)) + origStringArg.substring(start, result.endOffset(group));
                    sbuf.ensureCapacity(tmp.length());
                    sbuf.append(tmp);
                    first = nextSpecIndex;
                    continue;
                }
                sbuf.ensureCapacity(sbuf.length() + (specIndex - first));
                sbuf.append(subSpec.substring(first));
                break;
            }
            if (!all) break;
        }
        interp.setResult(numMatches);
        String value = numMatches == 0 ? origStringArg : (unmatchedIndex >= origStringArg.length() ? sbuf.toString() : String.valueOf(sbuf.toString()) + origStringArg.substring(unmatchedIndex));
        try {
            interp.setVar(varName, TclString.newInstance((String)value), 0);
            return;
        }
        catch (TclException tclException) {
            throw new TclException(interp, "couldn't set variable \"" + varName + "\"");
        }
    }
}

